/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureType;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.GetMap;

public class GetMapKvpRequestReader
extends KvpRequestReader
implements HttpServletRequestAware {
    GetMap getMap;
    HttpServletRequest httpRequest;
    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    boolean styleRequired;
    WMS wms;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$requests$GetMapRequest;

    public GetMapKvpRequestReader(GetMap getMap, WMS wms) {
        super(class$org$vfny$geoserver$wms$requests$GetMapRequest == null ? (class$org$vfny$geoserver$wms$requests$GetMapRequest = GetMapKvpRequestReader.class$("org.vfny.geoserver.wms.requests.GetMapRequest")) : class$org$vfny$geoserver$wms$requests$GetMapRequest);
        this.getMap = getMap;
        this.wms = wms;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setStyleFactory(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isStyleRequired() {
        return this.styleRequired;
    }

    public void setStyleRequired(boolean styleRequired) {
        this.styleRequired = styleRequired;
    }

    public Object createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest(this.getMap);
        request.setHttpServletRequest(this.httpRequest);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        GetMapRequest getMap = (GetMapRequest)((Object)super.read(request, kvp, rawKvp));
        String epsgCode = getMap.getSRS();
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
        if (getMap.getSldBody() != null) {
            List errors;
            if (KvpRequestReader.LOGGER.isLoggable(Level.FINE)) {
                KvpRequestReader.LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            if (getMap.getValidateSchema().booleanValue() && (errors = this.validateSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()))).size() != 0) {
                throw new WmsException(SLDValidator.getErrorMessage((InputStream)new ByteArrayInputStream(getMap.getSldBody().getBytes()), (List)errors));
            }
            StyledLayerDescriptor sld = this.parseSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()));
            GetMapKvpRequestReader.processSld(getMap, sld);
        } else {
            MapLayerInfo[] layers;
            if (getMap.getSld() != null) {
                InputStream input;
                if (KvpRequestReader.LOGGER.isLoggable(Level.FINE)) {
                    KvpRequestReader.LOGGER.fine("Getting layers and styles from reomte SLD");
                }
                URL sldUrl = getMap.getSld();
                if (getMap.getValidateSchema().booleanValue()) {
                    input = Requests.getInputStream((URL)sldUrl);
                    List errors = null;
                    try {
                        errors = this.validateSld(input);
                    }
                    finally {
                        input.close();
                    }
                    if (errors != null && errors.size() != 0) {
                        input = Requests.getInputStream((URL)sldUrl);
                        try {
                            throw new WmsException(SLDValidator.getErrorMessage((InputStream)input, (List)errors));
                        }
                        catch (Throwable throwable) {
                            input.close();
                            throw throwable;
                        }
                    }
                }
                input = Requests.getInputStream((URL)sldUrl);
                try {
                    StyledLayerDescriptor sld = this.parseSld(input);
                    GetMapKvpRequestReader.processSld(getMap, sld);
                }
                finally {
                    input.close();
                }
            }
            if (KvpRequestReader.LOGGER.isLoggable(Level.FINE)) {
                KvpRequestReader.LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
            }
            if (getMap.getLayers() != null) {
                ArrayList<MapLayerInfo> oldLayers = new ArrayList<MapLayerInfo>(Arrays.asList(getMap.getLayers()));
                ArrayList oldStyles = getMap.getStyles() != null ? new ArrayList(getMap.getStyles()) : new ArrayList();
                ArrayList<MapLayerInfo> newLayers = new ArrayList<MapLayerInfo>();
                ArrayList<Style> newStyles = new ArrayList<Style>();
                for (int i = 0; i < oldLayers.size(); ++i) {
                    Style style;
                    MapLayerInfo info = (MapLayerInfo)((Object)oldLayers.get(i));
                    Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                    if (info.getType() == MapLayerInfo.TYPE_BASEMAP) {
                        List subLayers = info.getSubLayers();
                        newLayers.addAll(subLayers);
                        List currStyles = info.getStyles();
                        for (int j = 0; j < subLayers.size(); ++j) {
                            Style currStyle;
                            MapLayerInfo currLayer = (MapLayerInfo)((Object)subLayers.get(j));
                            Style style3 = currStyle = currStyles.isEmpty() ? null : (Style)currStyles.get(j);
                            if (currStyle != null) {
                                newStyles.add(currStyle);
                                continue;
                            }
                            newStyles.add(currLayer.getDefaultStyle());
                        }
                        continue;
                    }
                    newLayers.add(info);
                    if (style != null) {
                        newStyles.add(style);
                        continue;
                    }
                    newStyles.add(info.getDefaultStyle());
                }
                getMap.setLayers(newLayers);
                getMap.setStyles(newStyles);
            }
            if ((layers = getMap.getLayers()) != null && layers.length > 0) {
                List styles = getMap.getStyles();
                if (layers.length != styles.size()) {
                    String msg = layers.length + " layers requested, but found " + styles.size() + " styles specified. " + "Since SLD parameter is not yet implemented, the STYLES parameter " + "is mandatory and MUST have exactly one value per requested layer";
                    throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
                }
                for (int i = 0; i < getMap.getStyles().size(); ++i) {
                    Style currStyle = (Style)getMap.getStyles().get(i);
                    MapLayerInfo currLayer = layers[i];
                    if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                        try {
                            GetMapKvpRequestReader.checkStyle(currStyle, layers[i].getFeature().getFeatureType());
                        }
                        catch (IOException e) {
                            throw new WmsException("Error obtaining FeatureType for layer " + layers[i].getName());
                        }
                        if (!KvpRequestReader.LOGGER.isLoggable(Level.FINE)) continue;
                        KvpRequestReader.LOGGER.fine("establishing " + currStyle.getName() + " style for " + layers[i].getName());
                        continue;
                    }
                    if (currLayer.getType() != MapLayerInfo.TYPE_RASTER) continue;
                }
            }
        }
        if (getMap.getLayers() != null && getMap.getLayers().length > 0) {
            List featureId;
            List<Id> filters = getMap.getFilter() != null ? getMap.getFilter() : Collections.EMPTY_LIST;
            List cqlFilters = getMap.getCQLFilter() != null ? getMap.getCQLFilter() : Collections.EMPTY_LIST;
            List list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.EMPTY_LIST;
            if (!featureId.isEmpty()) {
                if (!filters.isEmpty()) {
                    throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId);
                }
                HashSet<FeatureId> ids = new HashSet<FeatureId>();
                Iterator i = featureId.iterator();
                while (i.hasNext()) {
                    ids.add(this.filterFactory.featureId((String)i.next()));
                }
                filters = Collections.singletonList(this.filterFactory.id(ids));
            }
            if (!cqlFilters.isEmpty()) {
                if (!filters.isEmpty()) {
                    throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId + ", cql: " + cqlFilters);
                }
                filters = cqlFilters;
            }
            getMap.setFilter(filters);
            int numLayers = getMap.getLayers().length;
            if (!filters.isEmpty() && numLayers != filters.size()) {
                if (filters.size() == 1) {
                    Filter f = (Filter)filters.get(0);
                    filters = new ArrayList<Id>(numLayers);
                    for (int i = 0; i < numLayers; ++i) {
                        filters.add((Id)f);
                    }
                } else {
                    String msg = numLayers + " layers requested, but found " + filters.size() + " filters specified. " + "When you specify the FILTER parameter, you must provide just one, \n" + " that will be applied to all layers, or exactly one for each requested layer";
                    throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
                }
            }
        }
        getMap.setRawKvp(rawKvp);
        return getMap;
    }

    private List validateSld(InputStream input) {
        SLDValidator validator = new SLDValidator();
        return validator.validateSLD(input, this.httpRequest.getSession().getServletContext());
    }

    private StyledLayerDescriptor parseSld(InputStream input) {
        SLDParser parser = new SLDParser(this.styleFactory, input);
        return parser.parseSLD();
    }

    public static void processSld(GetMapRequest request, StyledLayerDescriptor sld) throws WmsException {
        StyledLayer[] styledLayers;
        int slCount;
        MapLayerInfo[] libraryModeLayers = null;
        if (request.getLayers() != null && request.getLayers().length > 0) {
            if (KvpRequestReader.LOGGER.isLoggable(Level.FINE)) {
                KvpRequestReader.LOGGER.fine("request comes in \"library\" mode");
            }
            libraryModeLayers = request.getLayers();
        }
        if ((slCount = (styledLayers = sld.getStyledLayers()).length) == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        Style currStyle = null;
        if (null != libraryModeLayers) {
            int lCount = libraryModeLayers.length;
            for (int i = 0; i < lCount; ++i) {
                block22: {
                    currLayer = libraryModeLayers[i];
                    if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                        currStyle = GetMapKvpRequestReader.findStyleOf(request, currLayer.getFeature(), styledLayers);
                    } else if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                        try {
                            currStyle = GetMapKvpRequestReader.findStyleOf(request, currLayer.getFeature(), styledLayers);
                        }
                        catch (WmsException wm) {
                            currStyle = GetMapKvpRequestReader.findStyle(request, "raster");
                            if (currStyle != null) break block22;
                            throw new WmsException(((Throwable)((Object)wm)).getMessage() + "  Also tried to use " + "the generic raster style 'raster', but it wasn't available.");
                        }
                    }
                }
                layers.add(currLayer);
                styles.add(currStyle);
            }
        } else {
            StyledLayer sl = null;
            for (int i = 0; i < slCount; ++i) {
                sl = styledLayers[i];
                String layerName = sl.getName();
                if (null == layerName) {
                    throw new WmsException("A UserLayer without layer name was passed");
                }
                currLayer = new MapLayerInfo();
                if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                    UserLayer ul = (UserLayer)sl;
                    try {
                        GetMapKvpRequestReader.initializeInlineFeatureLayer(request, ul, currLayer);
                    }
                    catch (Exception e) {
                        throw new WmsException(e);
                    }
                }
                try {
                    currLayer.setFeature(GetMapKvpReader.findFeatureLayer(request, layerName));
                }
                catch (WmsException e) {
                    currLayer.setCoverage(GetMapKvpReader.findCoverageLayer(request, layerName));
                }
                if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                    GetMapKvpRequestReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
                    continue;
                }
                if (currLayer.getType() != MapLayerInfo.TYPE_RASTER) continue;
                try {
                    GetMapKvpRequestReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
                    continue;
                }
                catch (WmsException wm) {
                    currStyle = GetMapKvpRequestReader.findStyle(request, "raster");
                    if (currStyle == null) {
                        throw new WmsException(((Throwable)((Object)wm)).getMessage() + "  Also tried to use " + "the generic raster style 'raster', but it wasn't available.");
                    }
                    layers.add(currLayer);
                    styles.add(currStyle);
                }
            }
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    public static void addStyles(GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List layers, List styles) throws WmsException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            for (t = 0; t < length; ++t) {
                boolean matches;
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() == null) continue;
                String ftc_name = ftc.getFeatureTypeName();
                try {
                    matches = currLayer.getFeature().getFeatureType().isDescendedFrom(null, ftc_name) || currLayer.getFeature().getFeatureType().getTypeName().equalsIgnoreCase(ftc_name);
                }
                catch (Exception e) {
                    matches = false;
                }
                if (matches) continue;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        for (t = 0; t < length; ++t) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyles[t]);
        }
    }

    public static Style findStyle(GetMapRequest request, String currStyleName) {
        Map configuredStyles = request.getWMS().getData().getStyles();
        Style currStyle = (Style)configuredStyles.get(currStyleName);
        return currStyle;
    }

    private static Style findStyleOf(GetMapRequest request, FeatureTypeInfo layer, StyledLayer[] styledLayers) throws WmsException {
        FeatureType type;
        Style style = null;
        String layerName = layer.getName();
        for (int i = 0; i < styledLayers.length; ++i) {
            StyledLayer sl = styledLayers[i];
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                Style[] styles = ((UserLayer)sl).getUserStyles();
                if (null == styles || 0 >= styles.length) break;
                style = styles[0];
                break;
            }
            if (sl instanceof NamedLayer) {
                Style[] styles = ((NamedLayer)sl).getStyles();
                if (null != styles && 0 < styles.length) {
                    style = styles[0];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpRequestReader.findStyle(request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + sl);
        }
        if (null == style) {
            style = layer.getDefaultStyle();
        }
        try {
            type = layer.getFeatureType();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error getting FeatureType, this should never happen!");
        }
        GetMapKvpRequestReader.checkStyle(style, type);
        return style;
    }

    private static void checkStyle(Style style, FeatureType fType) throws WmsException {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        int length = styleAttributes.length;
        for (int i = 0; i < length; ++i) {
            String attName = styleAttributes[i];
            if (fType.getAttributeType(attName) != null) continue;
            throw new WmsException("The requested Style can not be used with this featureType.  The style specifies an attribute of " + attName + " and the featureType definition is: " + fType);
        }
    }

    public static void initializeInlineFeatureLayer(GetMapRequest getMapRequest, UserLayer ul, MapLayerInfo currLayer) throws Exception {
        currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore()));
        if (ul.getInlineFeatureType().getDefaultGeometry().getCoordinateSystem() == null) {
            KvpRequestReader.LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            FeatureType currFt = ul.getInlineFeatureType();
            DefaultQuery q = new DefaultQuery(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            FeatureReader ilReader = ul.getInlineFeatureDatastore().getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
            DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(ilReader, (CoordinateReferenceSystem)crs));
            currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo((DataStore)reTypedDS));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

