/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.openlayers;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;

public class OpenLayersMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map.openlayers");
    private static final Set ignoredParameters = new HashSet();
    static Configuration cfg;
    WMS wms;
    Template template;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$map$openlayers$OpenLayersMapProducer;

    public OpenLayersMapProducer(WMS wms) {
        this.wms = wms;
    }

    public void abort() {
        this.mapContext = null;
        this.template = null;
    }

    public String getContentDisposition() {
        return null;
    }

    public String getContentType() throws IllegalStateException {
        return "text/html";
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            Template template = cfg.getTemplate("OpenLayersMapTemplate.ftl");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("context", (Object)this.mapContext);
            map.put("request", (Object)this.mapContext.getRequest());
            map.put("maxResolution", new Double(this.getMaxResolution(this.mapContext.getAreaOfInterest())));
            map.put("baseUrl", this.canonicUrl(this.mapContext.getRequest().getBaseUrl()));
            map.put("parameters", this.getLayerParameter(this.mapContext.getRequest().getHttpServletRequest()));
            map.put("units", this.getOLUnits(this.mapContext.getRequest()));
            if (this.mapContext.getLayerCount() == 1) {
                map.put("layerName", this.mapContext.getLayer(0).getTitle());
            } else {
                map.put("layerName", "Geoserver layers");
            }
            template.process(map, (Writer)new OutputStreamWriter(out));
        }
        catch (TemplateException e) {
            throw new WmsException(e);
        }
        this.mapContext = null;
        this.template = null;
    }

    private String getOLUnits(GetMapRequest request) {
        CoordinateReferenceSystem crs = request.getCrs();
        String result = crs instanceof ProjectedCRS ? "m" : "degrees";
        try {
            String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            if ("\ufffd".equals(unit) || "degrees".equals(unit) || "dd".equals(unit)) {
                result = "degrees";
            } else if ("m".equals(unit) || "meters".equals(unit)) {
                result = "m";
            } else if ("km".equals(unit) || "kilometers".equals(unit)) {
                result = "mi";
            } else if ("in".equals(unit) || "inches".equals(unit)) {
                result = "inches";
            } else if ("ft".equals(unit) || "feets".equals(unit)) {
                result = "ft";
            } else if ("mi".equals(unit) || "miles".equals(unit)) {
                result = "mi";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
        }
        return result;
    }

    private List getLayerParameter(HttpServletRequest request) {
        ArrayList result = new ArrayList();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            if (ignoredParameters.contains(paramName.toUpperCase())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", paramName);
            map.put("value", request.getParameter(paramName));
            result.add(map);
        }
        return result;
    }

    private String canonicUrl(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private double getMaxResolution(ReferencedEnvelope areaOfInterest) {
        double h;
        double w = areaOfInterest.getWidth();
        return (w > (h = areaOfInterest.getHeight()) ? w : h) / 256.0;
    }

    public void produceMap() throws WmsException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ignoredParameters.add("REQUEST");
        ignoredParameters.add("TILED");
        ignoredParameters.add("BBOX");
        ignoredParameters.add("SERVICE");
        ignoredParameters.add("VERSION");
        ignoredParameters.add("FORMAT");
        cfg = new Configuration();
        cfg.setClassForTemplateLoading(class$org$vfny$geoserver$wms$responses$map$openlayers$OpenLayersMapProducer == null ? (class$org$vfny$geoserver$wms$responses$map$openlayers$OpenLayersMapProducer = OpenLayersMapProducer.class$("org.vfny.geoserver.wms.responses.map.openlayers.OpenLayersMapProducer")) : class$org$vfny$geoserver$wms$responses$map$openlayers$OpenLayersMapProducer, "");
    }
}

