/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformer;
import org.vfny.geoserver.wms.responses.map.png.PNGMapProducer;

class KMZMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.kmz");
    PNGMapProducer mapProducer;
    KMLTransformer transformer;

    public KMZMapProducer(String mapFormat, String mime_type, WMS wms) {
        super(mapFormat, mime_type);
        this.mapProducer = new PNGMapProducer("image/png", "image/png", wms);
    }

    public void abort(Service gs) {
    }

    public void abort() {
        LOGGER.fine("aborting KMZ map response");
        this.mapContext = null;
        this.mapProducer = null;
        this.transformer = null;
    }

    public void produceMap() throws WmsException {
        this.transformer = new KMLTransformer();
        this.transformer.setKmz(true);
        this.transformer.setIndentation(3);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        ZipOutputStream zip = new ZipOutputStream(out);
        ZipEntry entry = new ZipEntry("wms.kml");
        zip.putNextEntry(entry);
        try {
            this.transformer.transform((Object)this.mapContext, zip);
            zip.closeEntry();
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer mapLayer = this.mapContext.getLayer(i);
            WMSMapContext mapContext = new WMSMapContext();
            mapContext.addLayer(mapLayer);
            mapContext.setRequest(this.mapContext.getRequest());
            mapContext.setMapHeight(this.mapContext.getMapHeight());
            mapContext.setMapWidth(this.mapContext.getMapWidth());
            mapContext.setAreaOfInterest(this.mapContext.getAreaOfInterest());
            mapContext.setBgColor(this.mapContext.getBgColor());
            mapContext.setBuffer(this.mapContext.getBuffer());
            mapContext.setContactInformation(this.mapContext.getContactInformation());
            mapContext.setKeywords(this.mapContext.getKeywords());
            mapContext.setAbstract(this.mapContext.getAbstract());
            mapContext.setTransparent(true);
            this.mapProducer.setMapContext(mapContext);
            this.mapProducer.produceMap();
            entry = new ZipEntry("layer_" + i + ".png");
            zip.putNextEntry(entry);
            this.mapProducer.writeTo(zip);
            zip.closeEntry();
        }
        zip.finish();
        ((FilterOutputStream)zip).flush();
    }

    public String getContentDisposition() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer layer = this.mapContext.getLayer(i);
            String title = layer.getFeatureSource().getSchema().getTypeName();
            if (title == null || title.equals("")) continue;
            sb.append(title).append("_");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "attachment; filename=" + sb.toString() + ".kmz";
        }
        return "attachment; filename=geoserver.kmz";
    }
}

