/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.jpeg;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.jpeg.JPEGMapProducer;

public final class JPEGMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "image/jpeg";

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equalsIgnoreCase(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(mapFormat + " not supported by this map producer");
        }
        return new JPEGMapProducer(MIME_TYPE, wms);
    }

    public String getName() {
        return "Joint Photographic Experts Group";
    }

    public Set getSupportedFormats() {
        return Collections.singleton(MIME_TYPE);
    }

    public boolean isAvailable() {
        try {
            return Class.forName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter") != null || Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageWriter") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

