/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.geotiff;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.spatialschema.geometry.Envelope;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class GeoTiffMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map.geotiff");
    private static final GridCoverageFactory factory = FactoryFinder.getGridCoverageFactory(null);

    public GeoTiffMapProducer(String oformat, String mime_type, WMS wms) {
        super(oformat, mime_type, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        GridCoverage2D gc = factory.create((CharSequence)"geotiff", image, (Envelope)new GeneralEnvelope((Envelope)this.mapContext.getAreaOfInterest()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        if (this.format.equalsIgnoreCase("image/tiff8") || this.mapContext.getPaletteInverter() != null) {
            image = this.forceIndexed8Bitmask(image);
        }
        ImageOutputStream imageOutStream = ImageIO.createImageOutputStream(outStream);
        GeoTiffWriter writer = new GeoTiffWriter((Object)imageOutStream);
        writer.write((GridCoverage)gc, null);
        imageOutStream.flush();
        imageOutStream.close();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

