/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.xml.sax.ContentHandler;

public abstract class GeoRSSTransformerBase
extends TransformerBase {
    protected static Logger LOGGER = Logger.getLogger("org.geoserver.georss");
    protected GeometryEncoding geometryEncoding = GeometryEncoding.LATLONG;

    public void setGeometryEncoding(GeometryEncoding geometryEncoding) {
        this.geometryEncoding = geometryEncoding;
    }

    abstract class GeoRSSTranslatorSupport
    extends TransformerBase.TranslatorSupport {
        public GeoRSSTranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI) {
            super(contentHandler, prefix, nsURI);
            this.nsSupport.declarePrefix(GeoRSSTransformerBase.this.geometryEncoding.getPrefix(), GeoRSSTransformerBase.this.geometryEncoding.getNamespaceURI());
        }

        protected void encodeGeometry(Feature feature) {
            if (feature.getDefaultGeometry() != null) {
                GeometryCollection mg;
                Geometry g = feature.getDefaultGeometry();
                if (g instanceof GeometryCollection && (mg = (GeometryCollection)g).getNumGeometries() == 1) {
                    g = mg.getGeometryN(0);
                }
                GeoRSSTransformerBase.this.geometryEncoding.encode(g, this);
            }
        }

        public void start(String element) {
            super.start(element);
        }

        public void element(String element, String content) {
            super.element(element, content);
        }

        protected List loadFeatureCollections(WMSMapContext map) throws IOException {
            ReferencedEnvelope mapArea = map.getAreaOfInterest();
            CoordinateReferenceSystem wgs84 = null;
            FilterFactory ff = FilterFactoryFinder.createFilterFactory();
            try {
                wgs84 = CRS.decode((String)"EPSG:4326");
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to decode WGS84...").initCause(e);
            }
            ArrayList<FeatureCollection> featureCollections = new ArrayList<FeatureCollection>();
            for (int i = 0; i < map.getLayerCount(); ++i) {
                MapLayer layer = map.getLayer(i);
                DefaultQuery query = new DefaultQuery(layer.getQuery());
                FeatureCollection features = null;
                try {
                    FeatureSource source = layer.getFeatureSource();
                    GeometryAttributeType at = source.getSchema().getDefaultGeometry();
                    if (at == null) {
                        features = source.getFeatures((Query)query);
                        continue;
                    }
                    ReferencedEnvelope env = new ReferencedEnvelope(mapArea);
                    CoordinateReferenceSystem sourceCRS = at.getCoordinateSystem();
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)mapArea.getCoordinateReferenceSystem(), (Object)sourceCRS)) {
                        env = env.transform(sourceCRS, true);
                    }
                    Filter original = query.getFilter();
                    GeometryFilter box = ff.createGeometryFilter((short)4);
                    box.addLeftGeometry((Expression)ff.createAttributeExpression(at.getName()));
                    box.addRightGeometry((Expression)ff.createBBoxExpression((Envelope)env));
                    query.setFilter(box.and(original));
                    features = source.getFeatures((Query)query);
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)wgs84, (Object)sourceCRS)) {
                        features = new ReprojectFeatureResults((FeatureResults)features, wgs84);
                    }
                    if (features == null) {
                        throw new NullPointerException();
                    }
                    featureCollections.add(features);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Unable to encode map layer: " + layer;
                    LOGGER.log(Level.SEVERE, msg, e);
                }
            }
            return featureCollections;
        }
    }

    public static class GeometryEncoding {
        public static GeometryEncoding SIMPLE = new GeometryEncoding(){

            public String getPrefix() {
                return "georss";
            }

            public String getNamespaceURI() {
                return "http://www.georss.org/georss";
            }

            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p;
                if (g instanceof Point) {
                    p = (Point)g;
                    t.element("georss:point", p.getX() + " " + p.getY());
                }
                if (g instanceof LineString) {
                    LineString l = (LineString)g;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < l.getNumPoints(); ++i) {
                        Coordinate c = l.getCoordinateN(i);
                        sb.append(c.x).append(" ").append(c.y).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:line", sb.toString());
                }
                if (g instanceof Polygon) {
                    p = (Polygon)g;
                    LineString line = p.getExteriorRing();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < line.getNumPoints(); ++i) {
                        Coordinate c = line.getCoordinateN(i);
                        sb.append(c.x).append(" ").append(c.y).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:polygon", sb.toString());
                }
            }
        };
        public static GeometryEncoding GML = new GeometryEncoding(){

            public String getPrefix() {
                return "gml";
            }

            public String getNamespaceURI() {
                return "http://www.opengis.net/gml";
            }
        };
        public static GeometryEncoding LATLONG = new GeometryEncoding(){

            public String getPrefix() {
                return "geo";
            }

            public String getNamespaceURI() {
                return "http://www.w3.org/2003/01/geo/wgs84_pos#";
            }

            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p = g.getCentroid();
                t.element("geo:lat", "" + p.getY());
                t.element("geo:long", "" + p.getX());
            }
        };

        private GeometryEncoding() {
        }

        public String getPrefix() {
            return null;
        }

        public String getNamespaceURI() {
            return null;
        }

        public void encode(Geometry g, GeoRSSTranslatorSupport translator) {
        }
    }
}

