/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class HTMLTableFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    private static Configuration templateConfig = new Configuration();
    GeoServerTemplateLoader templateLoader;

    public HTMLTableFeatureInfoResponse() {
        this.format = "text/html";
        this.supportedFormats = Collections.singletonList(this.format);
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.getRequest().getGeoServer().getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        FeatureType templateFeatureType = null;
        if (this.results.size() == 1) {
            templateFeatureType = ((FeatureCollection)this.results.get(0)).getSchema();
        }
        Template header = this.getTemplate(templateFeatureType, "header.ftl");
        Template footer = this.getTemplate(templateFeatureType, "footer.ftl");
        try {
            header.process(null, (Writer)osw);
            Iterator it = this.results.iterator();
            while (it.hasNext()) {
                FeatureCollection fc = (FeatureCollection)it.next();
                if (fc.size() <= 0) continue;
                FeatureType ft = fc.getSchema();
                Template content = this.getTemplate(ft, "content.ftl");
                content.process((Object)fc, (Writer)osw);
            }
            footer.process(null, (Writer)osw);
        }
        catch (TemplateException e) {
            String msg = "Error occured processing template.";
            throw (IOException)new IOException(msg).initCause(e);
        }
        osw.flush();
    }

    public String getContentDisposition() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Template getTemplate(FeatureType featureType, String templateFileName) throws IOException {
        if (this.templateLoader == null) {
            this.templateLoader = new GeoServerTemplateLoader(this.getClass());
        }
        this.templateLoader.setFeatureType(featureType);
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
            return templateConfig.getTemplate(templateFileName);
        }
    }

    static {
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
    }
}

