/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;

public class GetLegendGraphicResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$GetLegendGraphicResponse == null ? (class$org$vfny$geoserver$wms$responses$GetLegendGraphicResponse = GetLegendGraphicResponse.class$("org.vfny.geoserver.wms.responses.GetLegendGraphicResponse")) : class$org$vfny$geoserver$wms$responses$GetLegendGraphicResponse).getPackage().getName());
    private GetLegendGraphicProducer delegate;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$GetLegendGraphicResponse;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi;

    public GetLegendGraphicResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws ServiceException {
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)req;
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat);
        this.delegate.produceLegendGraphic(request);
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("returning content encoding null");
        }
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("asking delegate for aborting the process");
            }
            this.delegate.abort();
        }
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        block4: {
            try {
                if (this.delegate == null) {
                    throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("asking delegate for write to " + out);
                }
                this.delegate.writeTo(out);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block4;
                LOGGER.finer("asking delegate for write to " + out);
            }
        }
    }

    private GetLegendGraphicProducer getDelegate(String outputFormat) throws WmsException {
        Map beans = this.applicationContext.getBeansOfType(class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi == null ? (class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi = GetLegendGraphicResponse.class$("org.vfny.geoserver.wms.GetLegendGraphicProducerSpi")) : class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi);
        Collection producers = beans.values();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetLegendGraphicProducerSpi factory = (GetLegendGraphicProducerSpi)iter.next();
            if (!factory.canProduce(outputFormat)) continue;
            return factory.createLegendProducer(outputFormat);
        }
        throw new WmsException("There is no support for creating legends in " + outputFormat + " format", "InvalidFormat");
    }

    public static boolean supportsFormat(String mimeType, ApplicationContext context) {
        return GetLegendGraphicResponse.loadLegendFormats(context).contains(mimeType);
    }

    public static Set getFormats(ApplicationContext context) {
        return GetLegendGraphicResponse.loadLegendFormats(context);
    }

    private static Set loadLegendFormats(ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi == null ? (class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi = GetLegendGraphicResponse.class$("org.vfny.geoserver.wms.GetLegendGraphicProducerSpi")) : class$org$vfny$geoserver$wms$GetLegendGraphicProducerSpi);
        Collection producers = beans.values();
        HashSet formats = new HashSet();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetLegendGraphicProducerSpi producer = (GetLegendGraphicProducerSpi)iter.next();
            formats.addAll(producer.getSupportedFormats());
        }
        return formats;
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

