/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import org.vfny.geoserver.wms.responses.palette.EfficientInverseColorMapComputation;

public final class InverseColorMapRasterOp
implements RasterOp {
    public static final int DEFAULT_QUANTIZATION_COLORS = 5;
    public static final int DEFAULT_ALPHA_TH = 1;
    protected final IndexColorModel icm;
    protected int alphaThreshold;
    protected boolean hasAlpha;
    protected int transparencyIndex;
    protected EfficientInverseColorMapComputation invCM;

    public InverseColorMapRasterOp(IndexColorModel destCM, int quantizationColors, int alphaThreshold) {
        this.icm = destCM;
        this.alphaThreshold = alphaThreshold;
        this.hasAlpha = this.icm.hasAlpha();
        this.transparencyIndex = this.icm.getTransparentPixel();
        int mapSize = this.icm.getMapSize();
        byte[][] colorMap = new byte[3][this.hasAlpha ? mapSize - 1 : mapSize];
        if (this.hasAlpha) {
            byte[] r = new byte[mapSize];
            byte[] g = new byte[mapSize];
            byte[] b = new byte[mapSize];
            this.icm.getReds(r);
            this.icm.getGreens(g);
            this.icm.getBlues(b);
            int reducedMapSize = mapSize - 1;
            if (this.transparencyIndex == 0) {
                System.arraycopy(r, 1, colorMap[0], 0, reducedMapSize);
                System.arraycopy(g, 1, colorMap[1], 0, reducedMapSize);
                System.arraycopy(b, 1, colorMap[2], 0, reducedMapSize);
            } else if (this.transparencyIndex == mapSize - 1) {
                System.arraycopy(r, 0, colorMap[0], 0, reducedMapSize);
                System.arraycopy(g, 0, colorMap[1], 0, reducedMapSize);
                System.arraycopy(b, 0, colorMap[2], 0, reducedMapSize);
            } else {
                System.arraycopy(r, 0, colorMap[0], 0, this.transparencyIndex);
                System.arraycopy(g, 0, colorMap[1], 0, this.transparencyIndex);
                System.arraycopy(b, 0, colorMap[2], 0, this.transparencyIndex);
                System.arraycopy(r, this.transparencyIndex + 1, colorMap[0], this.transparencyIndex, reducedMapSize - this.transparencyIndex);
                System.arraycopy(g, this.transparencyIndex + 1, colorMap[1], this.transparencyIndex, reducedMapSize - this.transparencyIndex);
                System.arraycopy(b, this.transparencyIndex + 1, colorMap[2], this.transparencyIndex, reducedMapSize - this.transparencyIndex);
            }
        } else {
            this.icm.getReds(colorMap[0]);
            this.icm.getGreens(colorMap[1]);
            this.icm.getBlues(colorMap[2]);
        }
        this.invCM = new EfficientInverseColorMapComputation(colorMap, quantizationColors);
    }

    public InverseColorMapRasterOp(IndexColorModel destCM) {
        this(destCM, 5, 1);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return Raster.createBandedRaster(0, src.getWidth(), src.getHeight(), 1, new Point(src.getMinX(), src.getMinY()));
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (dest.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException("The destination raster for the IverseColorMapRasterOp must one one bad.");
        }
        int w = dest.getWidth();
        int h = dest.getHeight();
        int srcMinX = src.getMinX();
        int srcMinY = src.getMinY();
        int srcMaxX = srcMinX + w;
        int srcMaxY = srcMinY + h;
        int dstMinX = src.getMinX();
        int dstMinY = src.getMinY();
        int[] rgba = new int[src.getNumBands()];
        boolean sourceHasAlpha = src.getNumBands() % 2 == 0;
        int y = srcMinY;
        int y_ = dstMinY;
        while (y < srcMaxY) {
            int x = srcMinX;
            int x_ = dstMinX;
            while (x < srcMaxX) {
                src.getPixel(x, y, rgba);
                if (sourceHasAlpha && this.hasAlpha && rgba[3] >= this.alphaThreshold || !this.hasAlpha) {
                    int val = this.invCM.getIndexNearest(rgba[0] & 0xFF, rgba[1] & 0xFF, rgba[2]);
                    if (this.hasAlpha && val >= this.transparencyIndex) {
                        ++val;
                    }
                    dest.setSample(x_, y_, 0, (byte)(val & 0xFF));
                } else {
                    dest.setSample(x_, y_, 0, this.transparencyIndex);
                }
                ++x;
                ++x_;
            }
            ++y;
            ++y_;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return (Rectangle)src.getBounds().clone();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    EfficientInverseColorMapComputation getInvCM() {
        return this.invCM;
    }
}

