/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.TiledImage;

public final class CustomPaletteBuilder {
    protected int maxLevel;
    protected TiledImage src;
    protected ColorModel srcColorModel;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;
    protected int subsampleX;
    protected int subsampley;
    protected int numBands;

    public static boolean canCreatePalette(ImageTypeSpecifier type) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier type = new ImageTypeSpecifier(image);
        return CustomPaletteBuilder.canCreatePalette(type);
    }

    public RenderedImage getIndexedImage() {
        IndexColorModel icm = this.getIndexColorModel();
        BufferedImage dst = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, icm);
        int minx = this.src.getMinX();
        int miny = this.src.getMinY();
        int w = this.src.getWidth();
        int h = this.src.getHeight();
        WritableRaster wr = dst.getRaster();
        int y = 0;
        int ys = miny;
        while (y < h) {
            int x = 0;
            int xs = minx;
            while (x < w) {
                Color aColor = this.getSrcColor(xs, ys);
                try {
                    wr.setSample(x, y, 0, this.findColorIndex(this.root, aColor));
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++x;
                ++xs;
            }
            ++y;
            ++ys;
        }
        return dst;
    }

    public CustomPaletteBuilder(RenderedImage src) {
        this(src, 256, 1, 1);
    }

    public CustomPaletteBuilder(RenderedImage src, int size, int subsx, int subsy) {
        if (subsx <= 0 || subsx >= src.getWidth()) {
            throw new IllegalArgumentException("Invalid subsample x size");
        }
        if (subsy <= 0 || subsy >= src.getWidth()) {
            throw new IllegalArgumentException("Invalid subsample y size");
        }
        this.src = new TiledImage(src, true);
        this.srcColorModel = src.getColorModel();
        this.numBands = this.srcColorModel.getNumComponents();
        this.subsampleX = subsx;
        this.subsampley = subsy;
        this.transparency = this.srcColorModel.getTransparency();
        if (this.transparency != 1) {
            this.requiredSize = size - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = size;
        }
        if (this.requiredSize > 256) {
            throw new IllegalArgumentException("Unvalid number of colors require.");
        }
        this.maxLevel = (int)Math.ceil(Math.log(this.requiredSize) / Math.log(2.0));
    }

    private Color getSrcColor(int x, int y) {
        byte[] components = new byte[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            components[i] = (byte)(0xFF & this.src.getSample(x, y, i));
        }
        int argb = this.srcColorModel.getRGB(components);
        return new Color(argb, this.transparency != 1);
    }

    protected int findColorIndex(ColorNode aNode, Color aColor) {
        if (this.transparency != 1 && aColor.getAlpha() != 255) {
            return 0;
        }
        if (aNode.isLeaf) {
            return aNode.paletteIndex;
        }
        int childIndex = this.getBranchIndex(aColor, aNode.level);
        if (aNode.children[childIndex] == null) {
            for (int i = 1; i < 8; ++i) {
                if (childIndex + i < 8 && aNode.children[childIndex + i] != null) {
                    childIndex += i;
                    break;
                }
                if ((long)(childIndex - i) < 0L || aNode.children[childIndex - i] == null) continue;
                childIndex -= i;
                break;
            }
        }
        return this.findColorIndex(aNode.children[childIndex], aColor);
    }

    public CustomPaletteBuilder buildPalette() {
        this.reduceList = new ColorNode[this.maxLevel + 1];
        for (int i = 0; i < this.reduceList.length; ++i) {
            this.reduceList[i] = null;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = this.maxLevel;
        int minx = this.src.getMinX();
        int miny = this.src.getMinY();
        int w = this.src.getWidth();
        int h = this.src.getHeight();
        int maxx = w + minx;
        int maxy = h + miny;
        boolean discriminant = this.transparency != 1;
        for (int y = miny; y < maxy; ++y) {
            if (this.subsampley > 1 && y % this.subsampley != 0) continue;
            for (int x = minx; x < maxx; ++x) {
                if (this.subsampleX > 1 && x % this.subsampleX != 0) continue;
                Color aColor = this.getSrcColor(x, y);
                if (discriminant && aColor.getAlpha() != 255) {
                    this.transColor = this.insertNode(this.transColor, aColor, 0);
                } else {
                    this.root = this.insertNode(this.root, aColor, 0);
                }
                if (this.currSize <= this.requiredSize) continue;
                this.reduceTree();
            }
        }
        return this;
    }

    protected ColorNode insertNode(ColorNode aNode, Color aColor, int aLevel) {
        if (aNode == null) {
            aNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            aNode.level = aLevel;
            boolean bl = aNode.isLeaf = aLevel > this.maxLevel;
            if (aNode.isLeaf) {
                ++this.currSize;
            }
        }
        ++aNode.colorCount;
        aNode.red += (long)aColor.getRed();
        aNode.green += (long)aColor.getGreen();
        aNode.blue += (long)aColor.getBlue();
        if (!aNode.isLeaf) {
            int branchIndex = this.getBranchIndex(aColor, aLevel);
            if (aNode.children[branchIndex] == null) {
                ++aNode.childCount;
                if (aNode.childCount == 2) {
                    aNode.nextReducible = this.reduceList[aLevel];
                    this.reduceList[aLevel] = aNode;
                }
            }
            aNode.children[branchIndex] = this.insertNode(aNode.children[branchIndex], aColor, aLevel + 1);
        }
        return aNode;
    }

    public IndexColorModel getIndexColorModel() {
        int size = this.currSize;
        if (this.transparency == 2) {
            ++size;
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        int index = 0;
        this.palette = new ColorNode[size];
        if (this.transparency == 2) {
            ++index;
        }
        this.findPaletteEntry(this.root, index, red, green, blue);
        if (this.transparency == 2) {
            return new IndexColorModel(8, size, red, green, blue, 0);
        }
        return new IndexColorModel(8, this.currSize, red, green, blue);
    }

    protected int findPaletteEntry(ColorNode aNode, int index, byte[] red, byte[] green, byte[] blue) {
        if (aNode == null) {
            return index;
        }
        if (aNode.isLeaf) {
            red[index] = (byte)(aNode.red / (long)aNode.colorCount);
            green[index] = (byte)(aNode.green / (long)aNode.colorCount);
            blue[index] = (byte)(aNode.blue / (long)aNode.colorCount);
            aNode.paletteIndex = index;
            this.palette[index] = aNode;
            ++index;
        } else {
            for (int i = 0; i < 8; ++i) {
                if (aNode.children[i] == null) continue;
                index = this.findPaletteEntry(aNode.children[i], index, red, green, blue);
            }
        }
        return index;
    }

    protected int getBranchIndex(Color aColor, int aLevel) {
        if (aLevel > this.maxLevel || aLevel < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + aLevel);
        }
        int shift = this.maxLevel - aLevel;
        int red_index = 1 & (0xFF & aColor.getRed()) >> shift;
        int green_index = 1 & (0xFF & aColor.getGreen()) >> shift;
        int blue_index = 1 & (0xFF & aColor.getBlue()) >> shift;
        int index = red_index << 2 | green_index << 1 | blue_index;
        return index;
    }

    protected void reduceTree() {
        int level;
        for (level = this.reduceList.length - 1; this.reduceList[level] == null && level >= 0; --level) {
        }
        ColorNode thisNode = this.reduceList[level];
        if (thisNode == null) {
            return;
        }
        ColorNode pList = thisNode;
        int minColorCount = pList.colorCount;
        int cnt = 1;
        while (pList.nextReducible != null) {
            if (minColorCount > pList.nextReducible.colorCount) {
                thisNode = pList;
                minColorCount = pList.colorCount;
            }
            pList = pList.nextReducible;
            ++cnt;
        }
        if (thisNode == this.reduceList[level]) {
            this.reduceList[level] = thisNode.nextReducible;
        } else {
            pList = thisNode.nextReducible;
            thisNode.nextReducible = pList.nextReducible;
            thisNode = pList;
        }
        if (thisNode.isLeaf) {
            return;
        }
        int leafChildCount = thisNode.getLeafChildCount();
        thisNode.isLeaf = true;
        this.currSize -= leafChildCount - 1;
        int aDepth = thisNode.level;
        for (int i = 0; i < 8; ++i) {
            thisNode.children[i] = this.freeTree(thisNode.children[i]);
        }
        thisNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode aNode) {
        if (aNode == null) {
            return null;
        }
        for (int i = 0; i < 8; ++i) {
            aNode.children[i] = this.freeTree(aNode.children[i]);
        }
        --this.numNodes;
        return null;
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        ColorNode nextReducible;

        public ColorNode() {
            for (int i = 0; i < 8; ++i) {
                this.children[i] = null;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int cnt = 0;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.children[i].isLeaf) {
                    ++cnt;
                    continue;
                }
                cnt += this.children[i].getLeafChildCount();
            }
            return cnt;
        }

        public int getRGB() {
            int r = (int)this.red / this.colorCount;
            int g = (int)this.green / this.colorCount;
            int b = (int)this.blue / this.colorCount;
            int c = 0xFF000000 | (0xFF & r) << 16 | (0xFF & g) << 8 | 0xFF & b;
            return c;
        }
    }
}

