/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WMSMapContext;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class KMLUtils {
    public static String getMapUrl(WMSMapContext mapContext, MapLayer mapLayer, Envelope bbox, String[] kvp, boolean tile) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("service", "wms");
        map.put("request", "GetMap");
        map.put("version", "1.1.1");
        map.put("format", "image/png");
        map.put("layers", mapLayer.getTitle());
        map.put("styles", mapLayer.getStyle().getName());
        map.put("height", String.valueOf(mapContext.getMapHeight()));
        map.put("width", String.valueOf(mapContext.getMapWidth()));
        map.put("bbox", KMLUtils.encode(bbox));
        map.put("srs", "EPSG:4326");
        map.put("transparent", "true");
        for (int i = 0; kvp != null && i < kvp.length; i += 2) {
            map.put(kvp[i], kvp[i + 1]);
        }
        String baseUrl = null;
        if (tile) {
            baseUrl = Requests.getTileCacheBaseUrl((HttpServletRequest)mapContext.getRequest().getHttpServletRequest(), (GeoServer)mapContext.getRequest().getGeoServer());
        }
        if (baseUrl == null) {
            baseUrl = Requests.getBaseUrl((HttpServletRequest)mapContext.getRequest().getHttpServletRequest(), (GeoServer)mapContext.getRequest().getGeoServer());
            baseUrl = baseUrl + "wms?";
        }
        return KMLUtils.encode(mapContext, map, baseUrl);
    }

    public static String getMapUrl(WMSMapContext mapContext, MapLayer mapLayer, boolean tile) {
        return KMLUtils.getMapUrl(mapContext, mapLayer, (Envelope)mapContext.getAreaOfInterest(), null, tile);
    }

    public static String getLegendGraphicUrl(WMSMapContext mapContext, MapLayer mapLayer, String[] kvp) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("service", "wms");
        map.put("request", "GetLegendGraphic");
        map.put("version", "1.1.1");
        map.put("format", "image/png");
        map.put("layer", mapLayer.getTitle());
        map.put("style", mapLayer.getStyle().getName());
        map.put("height", "20");
        map.put("width", "20");
        for (int i = 0; kvp != null && i < kvp.length; i += 2) {
            map.put(kvp[i], kvp[i + 1]);
        }
        String baseUrl = Requests.getBaseUrl((HttpServletRequest)mapContext.getRequest().getHttpServletRequest(), (GeoServer)mapContext.getRequest().getGeoServer());
        baseUrl = baseUrl + "wms?";
        return KMLUtils.encode(mapContext, map, baseUrl);
    }

    static String encode(Envelope box) {
        return box.getMinX() + "," + box.getMinY() + "," + box.getMaxX() + "," + box.getMaxY();
    }

    static String encode(WMSMapContext mapContext, Map kvp, String baseUrl) {
        StringBuffer href = new StringBuffer(baseUrl);
        Iterator e = kvp.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            href.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        href.setLength(href.length() - 1);
        return href.toString();
    }

    public static Attributes attributes(String[] nameValuePairs) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            String name = nameValuePairs[i];
            String value = nameValuePairs[i + 1];
            attributes.addAttribute("", name, name, "", value);
        }
        return attributes;
    }
}

