/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.util.Date;
import java.util.logging.Level;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AtomGeoRSSTransformer
extends GeoRSSTransformerBase {
    public Translator createTranslator(ContentHandler handler) {
        return new AtomGeoRSSTranslator(handler);
    }

    public class AtomGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        public AtomGeoRSSTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, "http://www.w3.org/2005/Atom");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            this.start("feed");
            this.element("title", map.getTitle());
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, "http://localhost...");
            this.element("link", null, atts);
            this.element("updated", new Date().toString());
            this.encodeEntries(map);
            this.end("feed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeEntries(WMSMapContext map) {
            for (int i = 0; i < map.getLayerCount(); ++i) {
                MapLayer layer = map.getLayer(i);
                FeatureCollection features = null;
                try {
                    FeatureSource source = layer.getFeatureSource();
                    features = source.getFeatures();
                }
                catch (Exception e) {
                    String msg = "Unable to encode map layer: " + layer;
                    GeoRSSTransformerBase.LOGGER.log(Level.SEVERE, msg, e);
                }
                if (features == null) continue;
                FeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        this.encodeEntry(iterator.next());
                    }
                    continue;
                }
                finally {
                    if (iterator != null) {
                        features.close(iterator);
                    }
                }
            }
        }

        void encodeEntry(Feature feature) {
            this.start("entry");
            this.element("title", feature.getID());
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, "http://localhost...");
            this.element("link", null, atts);
            this.element("id", feature.getID());
            this.element("updated", new Date().toString());
            this.element("content", "some content");
            this.start("georss:where");
            this.encodeGeometry(feature);
            this.end("georss:where");
            this.end("entry");
        }
    }
}

