/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;

class LayerTree {
    private String name;
    private Collection childrens;
    private Collection data;

    public LayerTree(String name) {
        this.name = name;
        this.childrens = new ArrayList();
        this.data = new ArrayList();
    }

    public LayerTree(Collection c) {
        this.name = "";
        this.childrens = new ArrayList();
        this.data = new ArrayList();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo fLayer;
            String[] treeStructure;
            String wmsPath;
            Object element = it.next();
            if (element instanceof CoverageInfo) {
                CoverageInfo cLayer = (CoverageInfo)element;
                if (!cLayer.isEnabled()) continue;
                String string = wmsPath = cLayer.getWmsPath() != null && cLayer.getWmsPath().length() > 0 ? cLayer.getWmsPath() : "/";
                if (wmsPath.startsWith("/")) {
                    wmsPath = wmsPath.substring(1, wmsPath.length());
                }
                treeStructure = wmsPath.split("/");
                this.addToNode(this, treeStructure, cLayer);
                continue;
            }
            if (!(element instanceof FeatureTypeInfo) || !(fLayer = (FeatureTypeInfo)element).isEnabled()) continue;
            String string = wmsPath = fLayer.getWmsPath() != null && fLayer.getWmsPath().length() > 0 ? fLayer.getWmsPath() : "/";
            if (wmsPath.startsWith("/")) {
                wmsPath = wmsPath.substring(1, wmsPath.length());
            }
            treeStructure = wmsPath.split("/");
            this.addToNode(this, treeStructure, fLayer);
        }
    }

    private void addToNode(LayerTree tree, String[] treeStructure, CoverageInfo layer) {
        int length = treeStructure.length;
        if (length == 0 || treeStructure[0].length() == 0) {
            tree.data.add(layer);
        } else {
            LayerTree node = tree.getNode(treeStructure[0]);
            if (node == null) {
                node = new LayerTree(treeStructure[0]);
                tree.childrens.add(node);
            }
            String[] subTreeStructure = new String[length - 1];
            System.arraycopy(treeStructure, 1, subTreeStructure, 0, length - 1);
            this.addToNode(node, subTreeStructure, layer);
        }
    }

    private void addToNode(LayerTree tree, String[] treeStructure, FeatureTypeInfo layer) {
        int length = treeStructure.length;
        if (length == 0 || treeStructure[0].length() == 0) {
            tree.data.add(layer);
        } else {
            LayerTree node = tree.getNode(treeStructure[0]);
            if (node == null) {
                node = new LayerTree(treeStructure[0]);
                tree.childrens.add(node);
            }
            String[] subTreeStructure = new String[length - 1];
            System.arraycopy(treeStructure, 1, subTreeStructure, 0, length - 1);
            this.addToNode(node, subTreeStructure, layer);
        }
    }

    public LayerTree getNode(String name) {
        LayerTree node = null;
        Iterator it = this.childrens.iterator();
        while (it.hasNext()) {
            LayerTree tmpNode = (LayerTree)it.next();
            if (!tmpNode.name.equals(name)) continue;
            node = tmpNode;
        }
        return node;
    }

    public Collection getChildrens() {
        return this.childrens;
    }

    public Collection getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }
}

