/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.servlets;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.styling.Style;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.config.WMSConfig;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.requests.GetKMLReflectKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.servlets.WMService;

public class KMLReflector
extends WMService {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wms.servlets");
    static final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml";
    static final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz+xml";
    static final int KMSCORE = 30;
    static final boolean KMATTR = true;
    static final boolean TRANSPARENT = true;
    static final int WIDTH = 1024;
    static final int HEIGHT = 1024;
    static final String VERSION = "1.0.0";
    static final String SRS = "EPSG:4326";
    static final String DEFAULT_BBOX = "-180,-90,180,90";

    public KMLReflector(WMS wms) {
        super("kml_reflect", wms);
    }

    protected Response getResponseHandler() {
        WMSConfig config = (WMSConfig)((Object)this.getServletContext().getAttribute("Config.WMS"));
        return new GetMapResponse((WMS)this.getServiceRef(), (ApplicationContext)this.getApplicationContext());
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new GetKMLReflectKvpReader(params, this);
    }

    protected XmlRequestReader getXmlRequestReader() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GetMapRequest serviceRequest;
        response.setContentType(KML_MIME_TYPE);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        if (!requestParams.containsKey("BBOX")) {
            requestParams.put("BBOX", DEFAULT_BBOX);
        }
        KvpRequestReader requestReader = this.getKvpReader(requestParams);
        try {
            serviceRequest = (GetMapRequest)requestReader.getRequest(request);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        FeatureTypeInfo[] layers = serviceRequest.getLayers();
        LOGGER.info("KML NetworkLink sharing " + layers.length + " layer(s) created.");
        Style[] styles = null;
        if (serviceRequest.getStyles() != null && !serviceRequest.getStyles().isEmpty()) {
            styles = serviceRequest.getStyles().toArray(new Style[0]);
        }
        if (!requestParams.containsKey("TRANSPARENT")) {
            serviceRequest.setTransparent(true);
        }
        if (!requestParams.containsKey("KMATTR")) {
            serviceRequest.setKMattr(true);
        }
        if (!requestParams.containsKey("KMSCORE")) {
            serviceRequest.setKMScore(30);
        }
        if (!requestParams.containsKey("WIDTH")) {
            serviceRequest.setWidth(1024);
        }
        if (!requestParams.containsKey("HEIGHT")) {
            serviceRequest.setHeight(1024);
        }
        if (!requestParams.containsKey("VERSION")) {
            serviceRequest.setVersion(VERSION);
        }
        serviceRequest.setFormat(KML_MIME_TYPE);
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("<Folder>\n");
        for (int i = 0; i < layers.length; ++i) {
            String style = "&styles=" + layers[i].getDefaultStyle().getName();
            if (styles != null && styles.length >= i + 1) {
                style = "&styles=" + styles[i].getName();
            }
            sb.append("<NetworkLink>\n");
            sb.append("<name>" + layers[i].getName() + "</name>\n");
            sb.append("<open>1</open>\n");
            sb.append("<visibility>1</visibility>\n");
            sb.append("<Url>\n");
            sb.append("<href><![CDATA[" + serviceRequest.getBaseUrl() + "/wms?service=WMS&request=GetMap&format=application/vnd.google-earth.kmz+XML" + "&width=" + 1024 + "&height=" + 1024 + "&srs=" + SRS + "&layers=" + layers[i].getName() + style + "&KMScore=" + 30 + "&KMAttr=" + true + "]]></href>\n");
            sb.append("<viewRefreshMode>onStop</viewRefreshMode>\n");
            sb.append("<viewRefreshTime>3</viewRefreshTime>\n");
            sb.append("</Url>\n");
            sb.append("</NetworkLink>\n");
        }
        sb.append("</Folder>\n");
        sb.append("</kml>\n");
        byte[] kml_b = sb.toString().getBytes();
        out.write(kml_b);
        out.flush();
    }
}

