/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducer;

public class KMZMapProducerFactory
implements GetMapProducerFactorySpi {
    private static final String PRODUCE_TYPE = "kmz";
    static final String MIME_TYPE = "application/vnd.google-earth.kmz";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("application/vnd.google-earth.kmz");

    public String getName() {
        return "Keyhole markup language compressed producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return mapFormat != null && (mapFormat.startsWith(PRODUCE_TYPE) || mapFormat.startsWith(MIME_TYPE));
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        return new KMZMapProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

