/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.gif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.vfny.geoserver.wms.responses.map.gif.DirectGif89Frame;
import org.vfny.geoserver.wms.responses.map.gif.Gif89Frame;
import org.vfny.geoserver.wms.responses.map.gif.GifColorTable;
import org.vfny.geoserver.wms.responses.map.gif.IndexGif89Frame;
import org.vfny.geoserver.wms.responses.map.gif.NeuQuant;
import org.vfny.geoserver.wms.responses.map.gif.Put;

public class Gif89Encoder {
    private Dimension dispDim = new Dimension(0, 0);
    public GifColorTable colorTable;
    private int bgIndex = 0;
    private int loopCount = 1;
    private String theComments;
    private Vector vFrames = new Vector();
    private boolean[] transparentpixels = null;
    boolean DEBUG = false;

    public Gif89Encoder() {
        this.colorTable = new GifColorTable();
    }

    public BufferedImage prepareImage(BufferedImage image, Color transColor) throws IOException {
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (transColor == null) {
            transColor = new Color(255, 255, 255);
        }
        this.transparentpixels = new boolean[image.getWidth() * image.getHeight()];
        int width = image.getWidth();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int alphaValue = alphaRaster.getSample(x, y, 0);
                if (alphaValue == 0) {
                    image.setRGB(x, y, transColor.getRGB());
                    this.transparentpixels[y * width + x] = true;
                    continue;
                }
                this.transparentpixels[y * width + x] = false;
            }
        }
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 5);
        Graphics2D graphic = temp.createGraphics();
        graphic.setBackground(transColor);
        graphic.setColor(transColor);
        graphic.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphic.drawImage((Image)image, 0, 0, null);
        return temp;
    }

    public Gif89Encoder(BufferedImage image, Color transparentColor, int SAMPLE_FACTOR) throws IOException {
        boolean noTransparentColor;
        boolean bl = noTransparentColor = transparentColor == null;
        if (transparentColor == null) {
            transparentColor = Color.WHITE;
        }
        if (this.DEBUG) {
            System.out.println("Start GIF");
        }
        image = this.prepareImage(image, transparentColor);
        if (this.DEBUG) {
            System.out.println("   Prepared finished");
        }
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        boolean[] usedEntry = new boolean[256];
        int len = pixels.length;
        int nPix = len / 3;
        byte[] indexedPixels = new byte[nPix];
        NeuQuant nq = new NeuQuant(pixels, len, SAMPLE_FACTOR);
        if (this.DEBUG) {
            System.out.println("   Colour reduced being called");
        }
        byte[] colorTab = nq.process();
        if (this.DEBUG) {
            System.out.println("   Colour reducer call finished");
        }
        for (int i = 0; i < colorTab.length; i += 3) {
            byte temp = colorTab[i];
            colorTab[i] = colorTab[i + 2];
            colorTab[i + 2] = temp;
            usedEntry[i / 3] = false;
        }
        if (this.DEBUG) {
            System.out.println("   Colour reduced");
        }
        int k = 0;
        for (int i = 0; i < nPix; ++i) {
            int index = nq.map(pixels[k++] & 0xFF, pixels[k++] & 0xFF, pixels[k++] & 0xFF);
            usedEntry[index] = true;
            indexedPixels[i] = (byte)index;
        }
        if (this.DEBUG) {
            System.out.println("   Colour indexing mapped");
        }
        Color[] colors = new Color[256];
        for (int t = 0; t < 255; ++t) {
            int r = colorTab[t * 3];
            int g = colorTab[t * 3 + 1];
            int b = colorTab[t * 3 + 2];
            if (r < 0) {
                r = 256 + r;
            }
            if (g < 0) {
                g = 256 + g;
            }
            if (b < 0) {
                b = 256 + b;
            }
            colors[t] = new Color(r, g, b);
        }
        colors[255] = transparentColor;
        int trans_index = -1;
        if (!noTransparentColor) {
            trans_index = 255;
            byte transindx = (byte)trans_index;
            for (int t = 0; t < nPix; ++t) {
                if (!this.transparentpixels[t]) continue;
                indexedPixels[t] = transindx;
            }
        }
        if (this.DEBUG) {
            System.out.println("   transparency added");
        }
        this.colorTable = new GifColorTable(colors);
        this.addFrame(image.getWidth(), image.getHeight(), indexedPixels);
        if (trans_index != -1) {
            this.setTransparentIndex(trans_index);
        }
        if (this.DEBUG) {
            System.out.println("   --- finished prepare");
        }
    }

    protected int findClosest(Color c, byte[] colorTab, boolean[] usedEntry) {
        if (colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int minpos = 0;
        int dmin = 0x1000000;
        int len = colorTab.length / 3;
        for (int i = 0; i < len; ++i) {
            int dr = r - (colorTab[i * 3] & 0xFF);
            int dg = g - (colorTab[i * 3 + 1] & 0xFF);
            int db = b - (colorTab[i * 3 + 2] & 0xFF);
            int d = dr * dr + dg * dg + db * db;
            int index = i;
            if (!usedEntry[index] || d >= dmin) continue;
            dmin = d;
            minpos = index;
        }
        return minpos;
    }

    public Gif89Encoder(Color[] colors) throws Exception {
        throw new Exception("dont use this constructor - use the Gif89Encoder(img) constructor as its much smarter)");
    }

    public Gif89Encoder(Color[] colors, int width, int height, byte[] ci_pixels) throws Exception {
        this(colors);
        this.addFrame(width, height, ci_pixels);
    }

    public int getFrameCount() {
        return this.vFrames.size();
    }

    public Gif89Frame getFrameAt(int index) {
        return this.isOk(index) ? (Gif89Frame)this.vFrames.elementAt(index) : null;
    }

    public void addFrame(Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.addElement(gf);
    }

    public void addFrame(Image image) throws IOException {
        this.addFrame(new DirectGif89Frame(image));
    }

    public void addFrame(int width, int height, byte[] ci_pixels) throws IOException {
        this.addFrame(new IndexGif89Frame(width, height, ci_pixels));
    }

    public void insertFrame(int index, Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.insertElementAt(gf, index);
    }

    public void setTransparentIndex(int index) {
        this.colorTable.setTransparent(index);
    }

    public void setLogicalDisplay(Dimension dim, int background) {
        this.dispDim = new Dimension(dim);
        this.bgIndex = background;
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    public void setComments(String comments) {
        this.theComments = comments;
    }

    public void setUniformDelay(int interval) {
        for (int i = 0; i < this.vFrames.size(); ++i) {
            ((Gif89Frame)this.vFrames.elementAt(i)).setDelay(interval);
        }
    }

    public void encode(OutputStream out) throws IOException {
        int nframes = this.getFrameCount();
        boolean is_sequence = nframes > 1;
        this.colorTable.closePixelProcessing();
        Put.ascii("GIF89a", out);
        this.writeLogicalScreenDescriptor(out);
        this.colorTable.encode(out);
        if (is_sequence && this.loopCount != 1) {
            this.writeNetscapeExtension(out);
        }
        if (this.theComments != null && this.theComments.length() > 0) {
            this.writeCommentExtension(out);
        }
        for (int i = 0; i < nframes; ++i) {
            ((Gif89Frame)this.vFrames.elementAt(i)).encode(out, is_sequence, this.colorTable.getDepth(), this.colorTable.getTransparent());
        }
        out.write(59);
        out.flush();
        if (this.DEBUG) {
            System.out.println("done GIF!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("gif89out.gif"));
            if (args[0].toUpperCase().endsWith(".JPG")) {
                new Gif89Encoder((BufferedImage)tk.getImage(args[0]), null, 1).encode(out);
            } else {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(args[0]));
                Gif89Encoder ge = new Gif89Encoder();
                while ((line = in.readLine()) != null) {
                    ge.addFrame(tk.getImage(line.trim()));
                }
                ge.setLoopCount(0);
                ge.encode(out);
                in.close();
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private void accommodateFrame(Gif89Frame gf) throws IOException {
        this.dispDim.width = Math.max(this.dispDim.width, gf.getWidth());
        this.dispDim.height = Math.max(this.dispDim.height, gf.getHeight());
        this.colorTable.processPixels(gf);
    }

    private void writeLogicalScreenDescriptor(OutputStream os) throws IOException {
        Put.leShort(this.dispDim.width, os);
        Put.leShort(this.dispDim.height, os);
        os.write(0xF0 | this.colorTable.getDepth() - 1);
        os.write(this.bgIndex);
        os.write(0);
    }

    private void writeNetscapeExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(255);
        os.write(11);
        Put.ascii("NETSCAPE2.0", os);
        os.write(3);
        os.write(1);
        Put.leShort(this.loopCount > 1 ? this.loopCount - 1 : 0, os);
        os.write(0);
    }

    private void writeCommentExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(254);
        int remainder = this.theComments.length() % 255;
        int nsubblocks_full = this.theComments.length() / 255;
        int nsubblocks = nsubblocks_full + (remainder > 0 ? 1 : 0);
        int ibyte = 0;
        for (int isb = 0; isb < nsubblocks; ++isb) {
            int size = isb < nsubblocks_full ? 255 : remainder;
            os.write(size);
            Put.ascii(this.theComments.substring(ibyte, ibyte + size), os);
            ibyte += size;
        }
        os.write(0);
    }

    private boolean isOk(int frame_index) {
        return frame_index >= 0 && frame_index < this.vFrames.size();
    }

    public int getColorIndex(int rgb) {
        return this.colorTable.ciLookup.getPaletteIndex(rgb);
    }
}

