/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

class SVGWriter
extends OutputStreamWriter {
    private static DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(new Locale("en", "US"));
    private DecimalFormat formatter = new DecimalFormat();

    public SVGWriter(OutputStream out) {
        super(out);
        this.formatter.setDecimalFormatSymbols(decimalSymbols);
        this.formatter.setGroupingSize(0);
        this.formatter.setDecimalSeparatorAlwaysShown(false);
        this.formatter.setDecimalFormatSymbols(null);
        this.formatter.setMaximumFractionDigits(5);
        this.formatter.setMinimumFractionDigits(0);
    }

    public void setMaximunFractionDigits(int numDigits) {
        this.formatter.setMaximumFractionDigits(numDigits);
    }

    public int getMaximunFractionDigits() {
        return ((NumberFormat)this.formatter).getMaximumFractionDigits();
    }

    public void setMinimunFractionDigits(int numDigits) {
        this.formatter.setMinimumFractionDigits(numDigits);
    }

    public int getMinimunFractionDigits() {
        return ((NumberFormat)this.formatter).getMinimumFractionDigits();
    }

    public void write(double d) throws IOException {
        this.write(this.formatter.format(d));
    }

    public void write(char c) throws IOException {
        super.write(c);
    }

    public void newline() throws IOException {
        super.write(10);
    }

    public void writeAttribute(String attName, Object attValue) throws IOException {
        this.write(attName);
        this.write("=\"");
        if (attValue != null) {
            this.write(URLEncoder.encode(String.valueOf(attValue)));
        }
        this.write("\" ");
    }

    static {
        decimalSymbols.setDecimalSeparator('.');
    }
}

