/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.svg.EncodeSVG;

class SVGMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private EncodeSVG svgEncoder;

    SVGMapProducer() {
    }

    public void abort(Service gs) {
        this.svgEncoder.abort();
    }

    public String getContentType() {
        return "image/svg+xml";
    }

    public String getContentEncoding() {
        return null;
    }

    public void abort() {
        LOGGER.fine("aborting SVG map response");
        if (this.svgEncoder != null) {
            LOGGER.info("aborting SVG encoder");
            this.svgEncoder.abort();
        }
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        this.svgEncoder = new EncodeSVG(map);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.svgEncoder.encode(out);
    }

    public String getContentDisposition() {
        return null;
    }
}

