/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.util.Map;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WMSDTO;

public class WMS
extends Service {
    private static final String WMS_VERSION = "1.1.1";
    private static final String FIXED_SERVICE_NAME = "OGC:WMS";
    private static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml"};
    public static final String WEB_CONTAINER_KEY = "WMS";
    private String svgRenderer;
    private boolean svgAntiAlias;
    private Map baseMapLayers;
    private Map baseMapStyles;
    private WFS wfs;

    public WMS(WMSDTO config) {
        super(config.getService());
        this.svgRenderer = config.getSvgRenderer();
        this.svgAntiAlias = config.getSvgAntiAlias();
        this.baseMapLayers = config.getBaseMapLayers();
        this.baseMapStyles = config.getBaseMapStyles();
    }

    public WMS(Config config, Data data, GeoServer geoServer, WFS wfs) throws ConfigurationException {
        this(config.getXMLReader().getWms());
        this.setData(data);
        this.setGeoServer(geoServer);
        this.wfs = wfs;
    }

    public WFS getWFS() {
        return this.wfs;
    }

    public void load(WMSDTO config) {
        super.load(config.getService());
        this.svgRenderer = config.getSvgRenderer();
        this.svgAntiAlias = config.getSvgAntiAlias();
        this.baseMapLayers = config.getBaseMapLayers();
        this.baseMapStyles = config.getBaseMapStyles();
    }

    WMS() {
        super(new ServiceDTO());
    }

    public Object toDTO() {
        WMSDTO w = new WMSDTO();
        w.setService((ServiceDTO)super.toDTO());
        w.setSvgRenderer(this.svgRenderer);
        w.setSvgAntiAlias(this.svgAntiAlias);
        w.setBaseMapLayers(this.baseMapLayers);
        w.setBaseMapStyles(this.baseMapStyles);
        return w;
    }

    public String[] getExceptionFormats() {
        return EXCEPTION_FORMATS;
    }

    public String getName() {
        return FIXED_SERVICE_NAME;
    }

    public static String getVersion() {
        return WMS_VERSION;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return false;
    }

    public String getSvgRenderer() {
        return this.svgRenderer;
    }

    public void setSvgRenderer(String svgRenderer) {
        this.svgRenderer = svgRenderer;
    }

    public boolean isSvgAntiAlias() {
        return this.svgAntiAlias;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.svgAntiAlias = svgAntiAlias;
    }

    public Map getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public void setBaseMapLayers(Map layers) {
        this.baseMapLayers = layers;
    }

    public Map getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public void setBaseMapStyles(Map styles) {
        this.baseMapStyles = styles;
    }
}

