/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.util.HashMap;
import java.util.Map;
import org.vfny.geoserver.config.ServiceConfig;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.global.dto.WMSDTO;

public class WMSConfig
extends ServiceConfig {
    private static final String WMS_VERSION = "1.1.1";
    public static final String CONFIG_KEY = "Config.WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    private String svgRenderer;
    private boolean svgAntiAlias;
    private Map baseMapLayers;
    private Map baseMapStyles;

    public WMSConfig() {
        this.svgRenderer = SVG_SIMPLE;
        this.svgAntiAlias = true;
        this.baseMapLayers = new HashMap();
        this.baseMapStyles = new HashMap();
    }

    public WMSConfig(WMSDTO w) {
        super(w.getService());
        this.svgRenderer = w.getSvgRenderer();
        this.svgAntiAlias = w.getSvgAntiAlias();
        this.baseMapLayers = w.getBaseMapLayers();
        this.baseMapStyles = w.getBaseMapStyles();
    }

    public WMSConfig(WMS wms) {
        this((WMSDTO)wms.toDTO());
    }

    public void update(WMSDTO dto) {
        if (dto == null) {
            throw new NullPointerException("WMS Data Transfer Object required");
        }
        super.update(dto.getService());
        this.svgRenderer = dto.getSvgRenderer();
        this.svgAntiAlias = dto.getSvgAntiAlias();
        this.baseMapLayers = dto.getBaseMapLayers();
        this.baseMapStyles = dto.getBaseMapStyles();
    }

    public WMSDTO toDTO() {
        WMSDTO wmsDto = new WMSDTO();
        wmsDto.setService(super.toServDTO());
        wmsDto.setSvgRenderer(this.svgRenderer);
        wmsDto.setSvgAntiAlias(this.svgAntiAlias);
        wmsDto.setBaseMapLayers(this.baseMapLayers);
        wmsDto.setBaseMapStyles(this.baseMapStyles);
        return wmsDto;
    }

    public String getSvgRenderer() {
        return this.svgRenderer;
    }

    public void setSvgRenderer(String svgRenderer) {
        this.svgRenderer = svgRenderer;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.svgAntiAlias = svgAntiAlias;
    }

    public boolean getSvgAntiAlias() {
        return this.svgAntiAlias;
    }

    public Map getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public void setBaseMapLayers(Map layers) {
        this.baseMapLayers = layers;
    }

    public Map getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public void setBaseMapStyles(Map styles) {
        this.baseMapStyles = styles;
    }
}

