/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_0_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.vfny.geoserver.global.NameSpaceInfo;

public class WfsXmlReader
extends XmlRequestReader {
    WFSConfiguration configuration;

    public WfsXmlReader(String element, WFSConfiguration configuration) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.0.0"), "wfs");
        this.configuration = configuration;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        Parser parser = new Parser((Configuration)this.configuration);
        NameSpaceInfo[] namespaces = this.configuration.getCatalog().getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            if (namespaces[i].isDefault()) continue;
            parser.getNamespaces().declarePrefix(namespaces[i].getPrefix(), namespaces[i].getURI());
        }
        parser.setValidating(strict.booleanValue());
        Object parsed = parser.parse(reader);
        if (strict.booleanValue() && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            Iterator e = parser.getValidationErrors().iterator();
            while (e.hasNext()) {
                Exception error = (Exception)e.next();
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

