/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;

public class GML2OutputFormat
extends WFSGetFeatureOutputFormat {
    private static final int NO_FORMATTING = -1;
    private static final int INDENT_SIZE = 2;
    public static final String formatName = "GML2";
    public static final String formatNameCompressed = "GML2-GZIP";
    private FeatureTransformer transformer;
    private boolean compressOutput = false;
    private WFS wfs;
    private GeoServer geoServer;
    protected Data catalog;

    public GML2OutputFormat(WFS wfs, GeoServer geoServer, Data catalog) {
        super(new HashSet<String>(Arrays.asList(formatName, "text/xml; subtype=gml/2.1.2", formatNameCompressed)));
        this.wfs = wfs;
        this.geoServer = geoServer;
        this.catalog = catalog;
    }

    public String getCapabilitiesElementName() {
        return formatName;
    }

    public void prepare(String outputFormat, FeatureCollectionType results, GetFeatureType request) throws IOException {
        this.compressOutput = formatNameCompressed.equalsIgnoreCase(outputFormat);
        this.transformer = this.createTransformer();
        FeatureTransformer.FeatureTypeNamespaces ftNames = this.transformer.getFeatureTypeNamespaces();
        HashMap<String, String> ftNamespaces = new HashMap<String, String>();
        int srs = -1;
        for (int i = 0; i < results.getFeature().size(); ++i) {
            String location;
            FeatureCollection features = (FeatureCollection)results.getFeature().get(i);
            FeatureType featureType = features.getSchema();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(featureType.getTypeName(), featureType.getNamespace().toString());
            String prefix = meta.getNameSpace().getPrefix();
            String uri = meta.getNameSpace().getURI();
            ftNames.declareNamespace(features.getSchema(), prefix, uri);
            if (ftNamespaces.containsKey(uri)) {
                location = (String)ftNamespaces.get(uri);
                ftNamespaces.put(uri, location + "," + meta.getName());
            } else {
                location = this.typeSchemaLocation(this.wfs, meta, request.getBaseUrl());
                ftNamespaces.put(uri, location);
            }
            QueryType query = (QueryType)request.getQuery().get(i);
            try {
                if (query.getSrsName() != null) {
                    CoordinateReferenceSystem crs = CRS.decode((String)query.getSrsName().toString());
                    String epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)crs);
                    srs = Integer.parseInt(epsgCode);
                    continue;
                }
                srs = Integer.parseInt(meta.getSRS());
                continue;
            }
            catch (Exception e) {
                WFSGetFeatureOutputFormat.LOGGER.log(Level.WARNING, "Problem encoding:" + query.getSrsName(), e);
            }
        }
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        this.transformer.setIndentation(this.wfs.isVerbose() ? 2 : -1);
        this.transformer.setNumDecimals(this.geoServer.getNumDecimals());
        this.transformer.setFeatureBounding(this.wfs.isFeatureBounding());
        this.transformer.setEncoding(this.wfs.getCharSet());
        String wfsSchemaloc = this.wfsSchemaLocation(this.wfs, request.getBaseUrl());
        this.transformer.addSchemaLocation("http://www.opengis.net/wfs", wfsSchemaloc);
        Iterator it = ftNamespaces.keySet().iterator();
        while (it.hasNext()) {
            String uri = (String)it.next();
            this.transformer.addSchemaLocation(uri, (String)ftNamespaces.get(uri));
        }
        this.transformer.setGmlPrefixing(this.wfs.getCiteConformanceHacks());
        if (results.getLockId() != null) {
            this.transformer.setLockId(results.getLockId());
        }
        if (srs != -1) {
            this.transformer.setSrsName(this.wfs.getSrsPrefix() + srs);
        }
    }

    public String getContentEncoding() {
        return this.compressOutput ? "gzip" : null;
    }

    public void encode(OutputStream output, FeatureCollectionType results, GetFeatureType request) throws ServiceException, IOException {
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GZIPOutputStream gzipOut = null;
        if (this.compressOutput) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        EList resultsList = results.getFeature();
        FeatureCollection[] featureResults = resultsList.toArray(new FeatureCollection[resultsList.size()]);
        try {
            this.transformer.transform((Object)featureResults, output);
            if (gzipOut != null) {
                gzipOut.finish();
                ((FilterOutputStream)gzipOut).flush();
            }
        }
        catch (TransformerException gmlException) {
            String msg = " error:" + gmlException.getMessage();
            throw new ServiceException(msg, (Throwable)gmlException);
        }
    }

    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        GetFeatureType request = (GetFeatureType)getFeature.getParameters()[0];
        this.prepare(request.getOutputFormat(), featureCollection, request);
        this.encode(output, featureCollection, request);
    }

    protected FeatureTransformer createTransformer() {
        return new FeatureTransformer();
    }

    protected String wfsSchemaLocation(WFS wfs, String baseUrl) {
        return ResponseUtils.appendPath((String)RequestUtils.proxifiedBaseURL((String)baseUrl, (String)wfs.getGeoServer().getProxyBaseUrl()), (String)"schemas/wfs/1.0.0/WFS-basic.xsd");
    }

    protected String typeSchemaLocation(WFS wfs, FeatureTypeInfo meta, String baseUrl) {
        String proxifiedBase = RequestUtils.proxifiedBaseURL((String)baseUrl, (String)wfs.getGeoServer().getProxyBaseUrl());
        return ResponseUtils.appendQueryString((String)(proxifiedBase + "wfs"), (String)("service=WFS&version=1.0.0&request=DescribeFeatureType&typeName=" + meta.getName()));
    }
}

