/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.DefaultServiceExceptionHandler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geotools.util.Version;

public class WfsExceptionHandler
extends DefaultServiceExceptionHandler {
    WFS wfs;

    public WfsExceptionHandler(List services, WFS wfs) {
        super(services);
        this.wfs = wfs;
    }

    public void handleServiceException(ServiceException e, Service service, HttpServletRequest request, HttpServletResponse response) {
        Version version = service.getVersion();
        this.verboseExceptions = this.wfs.getGeoServer().isVerboseExceptions();
        if (new Version("1.0.0").equals((Object)version)) {
            this.handle1_0(e, response);
        } else {
            super.handleServiceException(e, service, request, response);
        }
    }

    public void handle1_0(ServiceException e, HttpServletResponse response) {
        try {
            String tab = "   ";
            StringBuffer s = new StringBuffer();
            s.append("<?xml version=\"1.0\" ?>\n");
            s.append("<ServiceExceptionReport\n");
            s.append(tab + "version=\"1.2.0\"\n");
            s.append(tab + "xmlns=\"http://www.opengis.net/ogc\"\n");
            s.append(tab + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            s.append(tab);
            s.append("xsi:schemaLocation=\"http://www.opengis.net/ogc ");
            s.append(ResponseUtils.appendPath((String)this.wfs.getSchemaBaseURL(), (String)"wfs/1.0.0/OGC-exception.xsd") + "\">\n");
            s.append(tab + "<ServiceException");
            if (e.getCode() != null && !e.getCode().equals("")) {
                s.append(" code=\"" + e.getCode() + "\"");
            }
            if (e.getLocator() != null && !e.getLocator().equals("")) {
                s.append(" locator=\"" + e.getLocator() + "\"");
            }
            s.append(">");
            if (e.getMessage() != null) {
                s.append("\n" + tab + tab);
                this.dumpExceptionMessages(e, s);
                if (this.verboseExceptions) {
                    ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(stackTrace));
                    s.append("\nDetails:\n");
                    s.append(ResponseUtils.encodeXML((String)new String(stackTrace.toByteArray())));
                }
            }
            s.append("\n</ServiceException>");
            s.append("</ServiceExceptionReport>");
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            response.getOutputStream().write(s.toString().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

