/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.util.logging.Logging;

public class ShapeZipOutputFormat
extends WFSGetFeatureOutputFormat {
    private final Logger LOGGER = Logging.getLogger((String)((Object)((Object)this)).getClass().toString());
    private String outputFileName;
    static /* synthetic */ Class class$net$opengis$wfs$GetFeatureType;

    public ShapeZipOutputFormat() {
        super("SHAPE-ZIP");
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/zip";
    }

    public String getCapabilitiesElementName() {
        return "SHAPE-ZIP";
    }

    protected boolean canHandleInternal(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), (Class)(class$net$opengis$wfs$GetFeatureType == null ? (class$net$opengis$wfs$GetFeatureType = ShapeZipOutputFormat.class$("net.opengis.wfs.GetFeatureType")) : class$net$opengis$wfs$GetFeatureType));
        this.outputFileName = ((QName)((QueryType)request.getQuery().get(0)).getTypeName().get(0)).getLocalPart();
        return true;
    }

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        return new String[][]{{"Content-Disposition", "attachment; filename=" + this.outputFileName + ".zip"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        File tempDir = this.createTempDirectory();
        ZipOutputStream zipOut = new ZipOutputStream(output);
        try {
            Iterator outputFeatureCollections = featureCollection.getFeature().iterator();
            while (outputFeatureCollections.hasNext()) {
                FeatureCollection curCollection = (FeatureCollection)outputFeatureCollections.next();
                this.writeCollectionToShapefile(curCollection, tempDir);
                String name = curCollection.getSchema().getTypeName();
                String outputName = name.replaceAll("\\.", "_");
                File f = new File(tempDir, name + ".shp");
                ZipEntry entry = new ZipEntry(outputName + ".shp");
                zipOut.putNextEntry(entry);
                FileInputStream shp_in = new FileInputStream(f);
                this.readInWriteOutBytes(zipOut, shp_in);
                zipOut.closeEntry();
                ((InputStream)shp_in).close();
                f = new File(tempDir, name + ".dbf");
                entry = new ZipEntry(outputName + ".dbf");
                zipOut.putNextEntry(entry);
                FileInputStream dbf_in = new FileInputStream(f);
                this.readInWriteOutBytes(zipOut, dbf_in);
                zipOut.closeEntry();
                ((InputStream)dbf_in).close();
                f = new File(tempDir, name + ".shx");
                entry = new ZipEntry(outputName + ".shx");
                zipOut.putNextEntry(entry);
                FileInputStream shx_in = new FileInputStream(f);
                this.readInWriteOutBytes(zipOut, shx_in);
                zipOut.closeEntry();
                ((InputStream)shx_in).close();
                f = new File(tempDir, name + ".prj");
                if (!f.exists()) continue;
                entry = new ZipEntry(outputName + ".prj");
                zipOut.putNextEntry(entry);
                FileInputStream prj_in = new FileInputStream(f);
                this.readInWriteOutBytes(zipOut, prj_in);
                zipOut.closeEntry();
                ((InputStream)prj_in).close();
            }
            zipOut.finish();
            ((FilterOutputStream)zipOut).flush();
            Object var17_16 = null;
            if (!this.removeDirectory(tempDir)) {
                this.LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (!this.removeDirectory(tempDir)) {
                this.LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath());
            }
            throw throwable;
        }
    }

    private boolean removeDirectory(File tempDir) {
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            return false;
        }
        File[] files = tempDir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.removeDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return tempDir.delete();
    }

    private void readInWriteOutBytes(OutputStream output, InputStream in) throws IOException {
        int c;
        while (-1 != (c = in.read())) {
            output.write(c);
        }
    }

    private void writeCollectionToShapefile(FeatureCollection c, File tempDir) {
        FeatureType schema = c.getSchema();
        try {
            File file = new File(tempDir, schema.getTypeName() + ".shp");
            ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
            try {
                sfds.createSchema(schema);
            }
            catch (NullPointerException e) {
                this.LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
                throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
            }
            FeatureStore store = (FeatureStore)sfds.getFeatureSource(schema.getTypeName());
            store.addFeatures(c);
            try {
                if (schema.getDefaultGeometry().getCoordinateSystem() != null) {
                    sfds.forceSchemaCRS(schema.getDefaultGeometry().getCoordinateSystem());
                }
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
            }
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
            throw new ServiceException((Throwable)ioe);
        }
    }

    private File createTempDirectory() {
        try {
            File dummyTemp = File.createTempFile("blah", null);
            String sysTempDir = dummyTemp.getParentFile().getAbsolutePath();
            dummyTemp.delete();
            File reqTempDir = new File(sysTempDir + File.separator + "wfsshptemp" + Math.random());
            reqTempDir.mkdir();
            return reqTempDir;
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "Unable to properly create a temporary directory when trying to output a shapefile.  Is the system temp directory writeable?", e);
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

