/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class LockFeature {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    WFS wfs;
    Data catalog;
    FilterFactory filterFactory;

    public LockFeature(WFS wfs, Data catalog) {
        this(wfs, catalog, null);
    }

    public LockFeature(WFS wfs, Data catalog, FilterFactory filterFactory) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockFeatureResponseType lockFeature(LockFeatureType request) throws WFSException {
        FeatureLock fLock = null;
        try {
            boolean lockAll;
            EList locks = request.getLock();
            if (locks == null || locks.isEmpty()) {
                String msg = "A LockFeature request must contain at least one LOCK element";
                throw new WFSException(msg);
            }
            LOGGER.info("locks size is " + locks.size());
            fLock = this.newFeatureLock(request);
            LockFeatureResponseType response = WfsFactory.eINSTANCE.createLockFeatureResponseType();
            response.setLockId(fLock.getAuthorization());
            response.setFeaturesLocked(WfsFactory.eINSTANCE.createFeaturesLockedType());
            response.setFeaturesNotLocked(WfsFactory.eINSTANCE.createFeaturesNotLockedType());
            int n = locks.size();
            for (int i = 0; i < n; ++i) {
                FeatureCollection features;
                FeatureSource source;
                FeatureTypeInfo meta;
                LockType lock = (LockType)locks.get(i);
                LOGGER.info("curLock is " + lock);
                QName typeName = lock.getTypeName();
                Filter filter = lock.getFilter();
                if (filter == null) {
                    filter = Filter.INCLUDE;
                }
                try {
                    meta = this.catalog.getFeatureTypeInfo(typeName.getLocalPart(), typeName.getNamespaceURI());
                    if (meta == null) {
                        throw new WFSException("Unknown feature type " + typeName.getPrefix() + ":" + typeName.getLocalPart());
                    }
                    source = meta.getFeatureSource();
                    CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(source.getSchema(), request.getVersion());
                    filter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
                    features = source.getFeatures(filter);
                    if (source instanceof FeatureLocking) {
                        ((FeatureLocking)source).setFeatureLock(fLock);
                    }
                }
                catch (IOException e) {
                    throw new WFSException(e);
                }
                Iterator reader = null;
                int numberLocked = -1;
                try {
                    reader = features.iterator();
                    while (reader.hasNext()) {
                        Feature feature = (Feature)reader.next();
                        FeatureId fid = this.fid(feature.getID());
                        Id fidFilter = this.fidFilter(fid);
                        if (!(source instanceof FeatureLocking)) {
                            LOGGER.fine("Lock " + fid + " not supported by data store (authID:" + fLock.getAuthorization() + ")");
                            response.getFeaturesNotLocked().getFeatureId().add(fid);
                            continue;
                        }
                        DefaultQuery query = new DefaultQuery(meta.getTypeName(), (Filter)fidFilter, Integer.MAX_VALUE, Query.ALL_NAMES, lock.getHandle());
                        numberLocked = ((FeatureLocking)source).lockFeatures((Query)query);
                        if (numberLocked == 1) {
                            LOGGER.fine("Lock " + fid + " (authID:" + fLock.getAuthorization() + ")");
                            response.getFeaturesLocked().getFeatureId().add(fid);
                            continue;
                        }
                        if (numberLocked == 0) {
                            LOGGER.fine("Lock " + fid + " conflict (authID:" + fLock.getAuthorization() + ")");
                            response.getFeaturesNotLocked().getFeatureId().add(fid);
                            continue;
                        }
                        LOGGER.warning("Lock " + numberLocked + " " + fid + " (authID:" + fLock.getAuthorization() + ") duplicated FeatureID!");
                        response.getFeaturesLocked().getFeatureId().add(fid);
                    }
                }
                catch (IOException ioe) {
                    throw new WFSException(ioe);
                }
                finally {
                    if (reader != null) {
                        features.close(reader);
                    }
                }
                if (numberLocked <= 0) continue;
                DefaultTransaction t = new DefaultTransaction();
                try {
                    try {
                        t.addAuthorization(response.getLockId());
                        source.getDataStore().getLockingManager().refresh(response.getLockId(), (Transaction)t);
                        continue;
                    }
                    finally {
                        t.commit();
                    }
                }
                catch (IOException e) {
                    throw new WFSException(e);
                }
            }
            boolean bl = lockAll = request.getLockAction() != AllSomeType.SOME_LITERAL;
            if (lockAll && !response.getFeaturesNotLocked().getFeatureId().isEmpty()) {
                throw new WFSException("Could not aquire locks for:" + response.getFeaturesNotLocked());
            }
            if (response.getFeaturesLocked().getFeatureId().isEmpty()) {
                response.setFeaturesLocked(null);
            }
            if (response.getFeaturesNotLocked().getFeatureId().isEmpty()) {
                response.setFeaturesNotLocked(null);
            }
            return response;
        }
        catch (WFSException e) {
            if (fLock != null) {
                try {
                    this.release(fLock.getAuthorization());
                }
                catch (WFSException e1) {
                    LOGGER.log(Level.SEVERE, "Error occured releasing locks", (Throwable)((Object)e1));
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            Set dataStores = this.catalog.getDataStores();
            Iterator i = dataStores.iterator();
            while (i.hasNext()) {
                DefaultTransaction t;
                block13: {
                    DataStore dataStore;
                    DataStoreInfo meta = (DataStoreInfo)i.next();
                    if (!meta.isEnabled()) continue;
                    try {
                        dataStore = meta.getDataStore();
                    }
                    catch (IllegalStateException notAvailable) {
                        continue;
                    }
                    LockingManager lockingManager = dataStore.getLockingManager();
                    if (lockingManager == null) continue;
                    t = new DefaultTransaction("Refresh " + meta.getNamesSpacePrefix());
                    t.addAuthorization(lockId);
                    if (!lockingManager.release(lockId, (Transaction)t)) break block13;
                    refresh = true;
                }
                Object var11_12 = null;
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
                continue;
                {
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        var11_12 = null;
                        try {
                            t.close();
                        }
                        catch (IOException closeException) {
                            LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    try {
                        t.close();
                        throw throwable;
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    throw throwable;
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public void releaseAll() throws WFSException {
        try {
            Set dataStores = this.catalog.getDataStores();
            Iterator i = dataStores.iterator();
            while (i.hasNext()) {
                DataStore dataStore;
                DataStoreInfo meta = (DataStoreInfo)i.next();
                if (!meta.isEnabled()) continue;
                try {
                    dataStore = meta.getDataStore();
                }
                catch (IllegalStateException notAvailable) {
                    continue;
                }
                catch (Throwable huh) {
                    continue;
                }
                LockingManager lockingManager = dataStore.getLockingManager();
                if (lockingManager != null) continue;
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public boolean exists(String lockId) throws WFSException {
        try {
            Set dataStores = this.catalog.getDataStores();
            Iterator i = dataStores.iterator();
            while (i.hasNext()) {
                DataStore dataStore;
                DataStoreInfo meta = (DataStoreInfo)i.next();
                if (!meta.isEnabled()) continue;
                try {
                    dataStore = meta.getDataStore();
                }
                catch (IllegalStateException notAvailable) {
                    continue;
                }
                LockingManager lockingManager = dataStore.getLockingManager();
                if (lockingManager == null || !lockingManager.exists(lockId)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(String lockId) throws WFSException {
        try {
            boolean refresh = false;
            Set dataStores = this.catalog.getDataStores();
            Iterator i = dataStores.iterator();
            while (i.hasNext()) {
                DefaultTransaction t;
                block13: {
                    DataStore dataStore;
                    DataStoreInfo meta = (DataStoreInfo)i.next();
                    if (!meta.isEnabled()) continue;
                    try {
                        dataStore = meta.getDataStore();
                    }
                    catch (IllegalStateException notAvailable) {
                        continue;
                    }
                    LockingManager lockingManager = dataStore.getLockingManager();
                    if (lockingManager == null) continue;
                    t = new DefaultTransaction("Refresh " + meta.getNamesSpacePrefix());
                    t.addAuthorization(lockId);
                    if (!lockingManager.refresh(lockId, (Transaction)t)) break block13;
                    refresh = true;
                }
                Object var11_12 = null;
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
                continue;
                {
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        var11_12 = null;
                        try {
                            t.close();
                        }
                        catch (IOException closeException) {
                            LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    try {
                        t.close();
                        throw throwable;
                    }
                    catch (IOException closeException) {
                        LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                    }
                    throw throwable;
                }
            }
            if (refresh) return;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    private FeatureId fid(String fid) {
        return this.filterFactory.featureId(fid);
    }

    private Id fidFilter(FeatureId fid) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(fid);
        return this.filterFactory.id(ids);
    }

    protected FeatureLock newFeatureLock(LockFeatureType request) {
        int lockExpiry;
        if (request.getHandle() == null || request.getHandle().equals("")) {
            request.setHandle("GeoServer");
        }
        if (request.getExpiry() == null) {
            request.setExpiry(BigInteger.valueOf(0L));
        }
        if ((lockExpiry = request.getExpiry().intValue()) < 0) {
            return FeatureLockFactory.generate((String)request.getHandle(), (long)lockExpiry);
        }
        if (lockExpiry == 0) {
            return FeatureLockFactory.generate((String)request.getHandle(), (long)0L);
        }
        return FeatureLockFactory.generate((String)request.getHandle(), (long)(lockExpiry * 60 * 1000));
    }
}

