/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class DescribeFeatureType {
    private Data catalog;
    private WFS wfs;

    public DescribeFeatureType(WFS wfs, Data catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFS getWFS() {
        return this.wfs;
    }

    public void setWFS(WFS wfs) {
        this.wfs = wfs;
    }

    public Data getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Data catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeType request) throws WFSException {
        ArrayList names = new ArrayList(request.getTypeName());
        Collection infos = this.catalog.getFeatureTypeInfos().values();
        ArrayList<Object> requested = new ArrayList<Object>();
        if (!names.isEmpty()) {
            Iterator t = names.iterator();
            block0: while (t.hasNext()) {
                QName name = (QName)t.next();
                Iterator h = infos.iterator();
                while (h.hasNext()) {
                    FeatureTypeInfo meta = (FeatureTypeInfo)h.next();
                    String namespace = meta.getNameSpace().getURI();
                    String local = meta.getTypeName();
                    if (!namespace.equals(name.getNamespaceURI()) || !local.equals(name.getLocalPart())) continue;
                    requested.add(meta);
                    continue block0;
                }
                String msg = "Could not find type: " + name;
                throw new WFSException(msg);
            }
        } else {
            requested.addAll(infos);
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

