/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DeleteElementHandler
implements TransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private WFS wfs;
    static /* synthetic */ Class class$net$opengis$wfs$DeleteElementType;

    public DeleteElementHandler(WFS wfs) {
        this.wfs = wfs;
    }

    public Class getElementClass() {
        return class$net$opengis$wfs$DeleteElementType == null ? (class$net$opengis$wfs$DeleteElementType = DeleteElementHandler.class$("net.opengis.wfs.DeleteElementType")) : class$net$opengis$wfs$DeleteElementType;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        return new QName[]{((DeleteElementType)element).getTypeName()};
    }

    public void checkValidity(EObject element, Map featureTypeInfos) throws WFSTransactionException {
        if ((this.wfs.getServiceLevel() & 8) == 0) {
            throw new WFSException("Transaction Delete support is not enabled");
        }
        DeleteElementType delete = (DeleteElementType)element;
        if (delete.getFilter() == null || Filter.INCLUDE.equals((Object)delete.getFilter())) {
            throw new WFSTransactionException("Must specify filter for delete", "MissingParameterValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        long deleted;
        block10: {
            DeleteElementType delete = (DeleteElementType)element;
            QName elementName = delete.getTypeName();
            String handle = delete.getHandle();
            deleted = response.getTransactionSummary().getTotalDeleted().longValue();
            FeatureStore store = (FeatureStore)featureStores.get(elementName);
            if (store == null) {
                throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
            }
            String typeName = store.getSchema().getTypeName();
            LOGGER.finer("Transaction Delete:" + element);
            try {
                Filter filter = delete.getFilter();
                CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
                filter = WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS);
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.PRE_DELETE, elementName, store.getFeatures(filter)));
                Envelope damaged = store.getBounds((Query)new DefaultQuery(delete.getTypeName().getLocalPart(), filter));
                if (damaged == null) {
                    damaged = store.getFeatures(filter).getBounds();
                }
                if (request.getLockId() != null && store instanceof FeatureLocking && request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                    FeatureLocking locking = (FeatureLocking)store;
                    DataStore data = store.getDataStore();
                    FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
                    FeatureWriter writer = data.getFeatureWriter(typeName, filter, store.getTransaction());
                    try {
                        while (writer.hasNext()) {
                            String fid = writer.next().getID();
                            HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                            featureIds.add(factory.featureId(fid));
                            locking.unLockFeatures((Filter)factory.id(featureIds));
                            writer.remove();
                            ++deleted;
                        }
                    }
                    finally {
                        writer.close();
                    }
                    store.removeFeatures(filter);
                    break block10;
                }
                deleted += (long)store.getFeatures(filter).size();
                store.removeFeatures(filter);
            }
            catch (IOException e) {
                String msg = e.getMessage();
                String eHandle = (String)EMFUtils.get((EObject)element, (String)"handle");
                throw new WFSTransactionException(msg, (String)null, eHandle, handle);
            }
        }
        response.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(deleted));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

