/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureType;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;

public class ShapeFeatureResponseDelegate
implements FeatureResponseDelegate {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wfs.responses");
    public static final String formatName = "SHAPE-ZIP";
    private static int counter = 0;
    String vmTempDir = null;
    private GetFeatureResults results;
    private String featureTypeName;

    public boolean canProduce(String outputFormat) {
        return formatName.equalsIgnoreCase(outputFormat);
    }

    public void prepare(String outputFormat, GetFeatureResults results) throws IOException {
        this.results = results;
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not succeed. <results> is null");
        }
        this.vmTempDir = System.getProperty("java.io.tmpdir");
        if (this.vmTempDir == null) {
            throw new NullPointerException("<tempDir> is null. There is a problem with the java.io.tempdir directory.");
        }
    }

    public String getContentType(GeoServer gs) {
        return "application/zip";
    }

    public String getContentEncoding() {
        return formatName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        ZipOutputStream zipOut = new ZipOutputStream(output);
        output = zipOut;
        File tempDir = this.createTempDirectory();
        try {
            List resultsList = this.results.getFeatures();
            FeatureResults[] featureResults = resultsList.toArray(new FeatureResults[resultsList.size()]);
            for (int i = 0; i < featureResults.length; ++i) {
                FeatureReader reader = featureResults[i].reader();
                String name = featureResults[i].getSchema().getTypeName();
                this.writeOut(name, tempDir, featureResults[i].getSchema(), reader);
                File f = new File(tempDir, name + ".shp");
                ZipEntry entry = new ZipEntry(name + ".shp");
                zipOut.putNextEntry(entry);
                FileInputStream shp_in = new FileInputStream(f);
                this.readInWriteOutBytes(output, shp_in);
                zipOut.closeEntry();
                ((InputStream)shp_in).close();
                f = new File(tempDir, name + ".dbf");
                entry = new ZipEntry(name + ".dbf");
                zipOut.putNextEntry(entry);
                FileInputStream dbf_in = new FileInputStream(f);
                this.readInWriteOutBytes(output, dbf_in);
                zipOut.closeEntry();
                ((InputStream)dbf_in).close();
                f = new File(tempDir, name + ".shx");
                entry = new ZipEntry(name + ".shx");
                zipOut.putNextEntry(entry);
                FileInputStream shx_in = new FileInputStream(f);
                this.readInWriteOutBytes(output, shx_in);
                zipOut.closeEntry();
                ((InputStream)shx_in).close();
                f = new File(tempDir, name + ".prj");
                entry = new ZipEntry(name + ".prj");
                zipOut.putNextEntry(entry);
                FileInputStream prj_in = new FileInputStream(f);
                this.readInWriteOutBytes(output, prj_in);
                zipOut.closeEntry();
                ((InputStream)prj_in).close();
            }
            zipOut.finish();
            ((FilterOutputStream)zipOut).flush();
            Object var16_16 = null;
            if (!this.removeDirectory(tempDir)) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (!this.removeDirectory(tempDir)) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath());
            }
            throw throwable;
        }
    }

    private boolean removeDirectory(File tempDir) {
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            return false;
        }
        File[] files = tempDir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.removeDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return tempDir.delete();
    }

    private void readInWriteOutBytes(OutputStream output, InputStream in) throws IOException {
        int byteRead;
        byte[] buffer = new byte[2048];
        while ((byteRead = in.read(buffer)) > 0) {
            output.write(buffer, 0, byteRead);
        }
    }

    private void writeOut(String name, File tempDir, FeatureType schema, FeatureReader reader) throws IOException, ServiceException {
        File file = new File(tempDir, name);
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        FeatureStore store = (FeatureStore)sfds.getFeatureSource(name);
        store.addFeatures(reader);
    }

    public String getContentDisposition(String featureTypeName) {
        return "attachment; filename=" + featureTypeName + ".zip";
    }

    private synchronized File createTempDirectory() throws IOException {
        File testFolder;
        while ((testFolder = new File(this.vmTempDir, "wfsshp" + ++counter)).exists() || !testFolder.mkdir()) {
        }
        return testFolder;
    }
}

