/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.TransformerException;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureResults;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.producer.FeatureTransformer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;

public class GML2FeatureResponseDelegate
implements FeatureResponseDelegate {
    private static final int NO_FORMATTING = -1;
    private static final int INDENT_SIZE = 2;
    public static final String formatName = "GML2";
    public static final String formatNameCompressed = "GML2-GZIP";
    private FeatureTransformer transformer;
    private boolean compressOutput = false;
    private GetFeatureResults results;

    public boolean canProduce(String outputFormat) {
        return formatName.equalsIgnoreCase(outputFormat) || formatNameCompressed.equalsIgnoreCase(outputFormat);
    }

    public void prepare(String outputFormat, GetFeatureResults results) throws IOException {
        int serverMaxFeatures;
        this.compressOutput = formatNameCompressed.equalsIgnoreCase(outputFormat);
        this.results = results;
        FeatureRequest request = results.getRequest();
        GeoServer config = request.getWFS().getGeoServer();
        this.transformer = new FeatureTransformer();
        FeatureTransformer.FeatureTypeNamespaces ftNames = this.transformer.getFeatureTypeNamespaces();
        int maxFeatures = request.getMaxFeatures();
        if (maxFeatures > (serverMaxFeatures = config.getMaxFeatures())) {
            maxFeatures = serverMaxFeatures;
        }
        StringBuffer typeNames = new StringBuffer();
        FeatureTypeInfo meta = null;
        int resCount = results.getResultsetsCount();
        HashMap<String, String> ftNamespaces = new HashMap<String, String>(resCount);
        for (int resIndex = 0; resIndex < resCount; ++resIndex) {
            FeatureResults features = results.getFeatures(resIndex);
            meta = results.getTypeInfo(resIndex);
            NameSpaceInfo namespace = meta.getDataStoreInfo().getNameSpace();
            String uri = namespace.getUri();
            ftNames.declareNamespace(features.getSchema(), namespace.getPrefix(), uri);
            if (ftNamespaces.containsKey(uri)) {
                String location = (String)ftNamespaces.get(uri);
                ftNamespaces.put(uri, location + "," + meta.getName());
                continue;
            }
            ftNamespaces.put(uri, request.getBaseUrl() + "wfs/" + "DescribeFeatureType?typeName=" + meta.getName());
        }
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        this.transformer.setIndentation(config.isVerbose() ? 2 : -1);
        this.transformer.setNumDecimals(config.getNumDecimals());
        this.transformer.setFeatureBounding(request.getWFS().isFeatureBounding());
        this.transformer.setEncoding(request.getWFS().getGeoServer().getCharSet());
        String wfsSchemaLoc = request.getSchemaBaseUrl() + "wfs/1.0.0/WFS-basic.xsd";
        this.transformer.addSchemaLocation("http://www.opengis.net/wfs", wfsSchemaLoc);
        Iterator it = ftNamespaces.keySet().iterator();
        while (it.hasNext()) {
            String uri = (String)it.next();
            this.transformer.addSchemaLocation(uri, (String)ftNamespaces.get(uri));
        }
        this.transformer.setGmlPrefixing(request.getWFS().getCiteConformanceHacks());
        FeatureLock featureLock = results.getFeatureLock();
        if (featureLock != null) {
            this.transformer.setLockId(featureLock.getAuthorization());
        }
        this.transformer.setSrsName(request.getWFS().getSrsPrefix() + meta.getSRS());
    }

    public String getContentType(GeoServer gs) {
        return this.compressOutput ? "application/gzip" : gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GZIPOutputStream gzipOut = null;
        if (this.compressOutput) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        List resultsList = this.results.getFeatures();
        FeatureCollection[] featureResults = resultsList.toArray(new FeatureCollection[resultsList.size()]);
        try {
            this.transformer.transform((Object)featureResults, output);
            if (gzipOut != null) {
                gzipOut.finish();
                ((FilterOutputStream)gzipOut).flush();
            }
        }
        catch (TransformerException gmlException) {
            ServiceException serviceException = new ServiceException(this.results.getRequest().getHandle() + " error:" + gmlException.getMessage());
            serviceException.initCause(gmlException);
            throw serviceException;
        }
    }

    public String getContentDisposition(String featureTypeName) {
        if (this.compressOutput) {
            return "attachment; filename=" + featureTypeName + ".gml.gz";
        }
        return "inline; filename=" + featureTypeName + ".gml";
    }
}

