/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class FeatureBoundsFeatureCollection
extends AbstractFeatureCollection {
    FeatureCollection wrapped;

    public FeatureBoundsFeatureCollection(FeatureCollection wrapped, FeatureType targetSchema) {
        super(targetSchema);
        this.wrapped = wrapped;
    }

    protected void closeIterator(Iterator close) {
        ((BoundsIterator)close).close();
    }

    protected Iterator openIterator() {
        return new BoundsIterator(this.wrapped.features(), this.getSchema());
    }

    public int size() {
        return this.wrapped.size();
    }

    private static class BoundedFeature
    implements Feature {
        private Feature wrapped;
        private FeatureType type;

        public BoundedFeature(Feature wrapped, FeatureType type) {
            this.wrapped = wrapped;
            this.type = type;
        }

        public Object getAttribute(int index) {
            return this.wrapped.getAttribute(this.type.getAttributeType(index).getName());
        }

        public Object getAttribute(String path) {
            if (this.type.getAttributeType(path) == null) {
                return null;
            }
            return this.wrapped.getAttribute(path);
        }

        public Object[] getAttributes(Object[] attributes) {
            Object[] retval = attributes != null ? attributes : new Object[this.type.getAttributeCount()];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = this.wrapped.getAttribute(this.type.getAttributeType(i).getName());
            }
            return retval;
        }

        public Envelope getBounds() {
            CoordinateReferenceSystem crs;
            if (this.wrapped.getFeatureType().getDefaultGeometry() != null && (crs = this.wrapped.getFeatureType().getDefaultGeometry().getCoordinateSystem()) != null) {
                return new ReferencedEnvelope(this.wrapped.getBounds(), crs);
            }
            return this.wrapped.getBounds();
        }

        public Geometry getDefaultGeometry() {
            GeometryAttributeType defaultGeometry = this.type.getDefaultGeometry();
            if (defaultGeometry == null) {
                return null;
            }
            return (Geometry)this.wrapped.getAttribute(defaultGeometry.getName());
        }

        public FeatureType getFeatureType() {
            return this.type;
        }

        public String getID() {
            return this.wrapped.getID();
        }

        public int getNumberOfAttributes() {
            return this.type.getAttributeCount();
        }

        public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }

        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }

        public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
            throw new UnsupportedOperationException("This feature wrapper is read only");
        }

        public FeatureCollection getParent() {
            return this.wrapped.getParent();
        }

        public void setParent(FeatureCollection collection) {
            this.wrapped.setParent(collection);
        }
    }

    private static class BoundsIterator
    implements Iterator {
        FeatureIterator wrapped;
        FeatureType targetSchema;

        public BoundsIterator(FeatureIterator wrapped, FeatureType targetSchema) {
            this.wrapped = wrapped;
            this.targetSchema = targetSchema;
        }

        public void close() {
            this.wrapped.close();
        }

        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        public Object next() throws NoSuchElementException {
            Feature base = this.wrapped.next();
            return new BoundedFeature(base, this.targetSchema);
        }

        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported");
        }
    }
}

