/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.Filter;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.requests.FeatureWithLockRequest;
import org.vfny.geoserver.wfs.requests.WfsKvpRequestReader;
import org.vfny.geoserver.wfs.servlets.WFService;

public class GetFeatureKvpReader
extends WfsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");

    public GetFeatureKvpReader(Map kvPairs, WFService service) {
        super(kvPairs, service);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        return this.getRequest(false, request);
    }

    public FeatureRequest getRequest(boolean withLock, HttpServletRequest srequest) throws WfsException {
        FeatureRequest currentRequest = new FeatureRequest((WFService)this.service);
        currentRequest.setHttpServletRequest(srequest);
        boolean useLock = false;
        if (withLock || this.keyExists("REQUEST")) {
            String request = this.getValue("REQUEST");
            boolean bl = useLock = withLock || request.equalsIgnoreCase("GETFEATUREWITHLOCK");
            if (useLock) {
                currentRequest = new FeatureWithLockRequest((WFService)this.getServiceRef());
            }
            currentRequest.setRequest(request);
        }
        LOGGER.finest("setting global request parameters");
        if (this.keyExists("MAXFEATURES")) {
            currentRequest.setMaxFeatures(this.getValue("MAXFEATURES"));
        }
        if (this.keyExists("VERSION")) {
            currentRequest.setVersion(this.getValue("VERSION"));
        }
        if (this.keyExists("REQUEST")) {
            currentRequest.setRequest(this.getValue("REQUEST"));
        }
        if (this.keyExists("FEATUREVERSION")) {
            currentRequest.setFeatureVersion(this.getValue("FEATUREVERSION"));
        }
        if (this.keyExists("OUTPUTFORMAT")) {
            currentRequest.setOutputFormat(this.getValue("OUTPUTFORMAT"));
        }
        if (useLock && this.keyExists("EXPIRY")) {
            ((FeatureWithLockRequest)currentRequest).setExpiry(Integer.parseInt(this.getValue("EXPIRY")));
        }
        LOGGER.finest("setting query request parameters");
        List typeList = KvpRequestReader.readFlat((String)this.getValue("TYPENAME"), (String)",");
        List propertyList = KvpRequestReader.readNested((String)this.getValue("PROPERTYNAME"));
        String fidKvps = this.getValue("FEATUREID");
        List filterList = this.readFilters(typeList, fidKvps, this.getValue("FILTER"), this.getValue("CQL_FILTER"), this.getValue("BBOX"));
        int propertySize = propertyList.size();
        int filterSize = filterList.size();
        if (typeList.size() == 0 && (typeList = this.getTypesFromFids(fidKvps)).size() == 0) {
            throw new WfsException("The typename element is mandatory if no FEATUREID is present");
        }
        int featureSize = typeList.size();
        if (propertySize != featureSize && propertySize > 1 || filterSize != featureSize && filterSize > 1) {
            throw new WfsException("Properties or filter sizes do not match feature types.  Property size: " + propertySize + " Filter size: " + filterSize + " Feature size: " + featureSize);
        }
        LOGGER.finest("setting query request parameters");
        for (int i = 0; i < featureSize; ++i) {
            String featureType = (String)typeList.get(i);
            LOGGER.finest("setting properties: " + i);
            List properties = propertySize == 0 ? null : (propertySize == 1 ? (List)propertyList.get(0) : (List)propertyList.get(i));
            LOGGER.finest("setting filters: " + i);
            Filter filter = filterSize == 0 ? null : (filterSize == 1 ? (Filter)filterList.get(0) : (Filter)filterList.get(i));
            LOGGER.finest("query filter: " + filter);
            currentRequest.addQuery(GetFeatureKvpReader.makeQuery(featureType, properties, filter));
        }
        return currentRequest;
    }

    private static Query makeQuery(String featureType, List propertyNames, Filter filter) {
        Query currentQuery = new Query();
        currentQuery.setTypeName(featureType);
        if (propertyNames != null) {
            for (int i = 0; i < propertyNames.size(); ++i) {
                currentQuery.addPropertyName((String)propertyNames.get(i));
            }
        }
        if (filter != null) {
            currentQuery.addFilter(filter);
        }
        return currentQuery;
    }
}

