/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.GeometryFilter;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.servlets.WFService;

public abstract class WfsKvpRequestReader
extends KvpRequestReader {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");

    public WfsKvpRequestReader(Map kvpPairs, WFService service) {
        super(kvpPairs, (AbstractService)service);
    }

    protected List readFilters(List typeNames, String fid, String ogcFilter, String cqlFilter, String bbox) throws WfsException {
        if (fid != null && ogcFilter == null && bbox == null & cqlFilter == null) {
            return this.readFidFilters(fid);
        }
        if (ogcFilter != null && fid == null && bbox == null & cqlFilter == null) {
            return this.readOGCFilter(ogcFilter);
        }
        if (cqlFilter != null && fid == null && ogcFilter == null & bbox == null) {
            return this.readCQLFilter(cqlFilter);
        }
        if (bbox != null && fid == null && ogcFilter == null & cqlFilter == null) {
            return this.parseBBoxFilter(typeNames, ogcFilter, bbox);
        }
        if (bbox == null && fid == null && ogcFilter == null & cqlFilter == null) {
            return new ArrayList();
        }
        throw new WfsException("GetFeature KVP request contained conflicting filters.  Filter: " + ogcFilter + ", fid: " + fid + ", bbox:" + bbox);
    }

    protected List parseBBoxFilter(List typeNames, String filter, String bbox) throws WfsException {
        ArrayList<GeometryFilter> filters = new ArrayList<GeometryFilter>();
        LOGGER.finest("bbox filter: " + bbox);
        try {
            Envelope envelope = this.parseBbox(bbox);
            BBoxExpression bboxExpression = KvpRequestReader.factory.createBBoxExpression(envelope);
            Iterator it = typeNames.iterator();
            while (it.hasNext()) {
                String typeName = (String)it.next();
                GeometryFilter finalFilter = KvpRequestReader.factory.createGeometryFilter((short)7);
                if (this.service.getCatalog() != null) {
                    FeatureTypeInfo info = this.service.getCatalog().getFeatureTypeInfo(typeName);
                    GeometryAttributeType geomAtt = info.getFeatureType().getDefaultGeometry();
                    finalFilter.addLeftGeometry((Expression)KvpRequestReader.factory.createAttributeExpression(geomAtt.getName()));
                }
                finalFilter.addRightGeometry((Expression)bboxExpression);
                filters.add(finalFilter);
            }
            return filters;
        }
        catch (ServiceException e) {
            throw new WfsException(e);
        }
        catch (Exception e) {
            throw new WfsException("Filter creation problem: " + filter, e);
        }
    }

    protected List readOGCFilter(String filter) throws WfsException {
        try {
            return super.readOGCFilter(filter);
        }
        catch (ServiceException e) {
            throw new WfsException(e);
        }
    }

    protected List readCQLFilter(String filter) throws WfsException {
        try {
            return super.readCQLFilter(filter);
        }
        catch (ServiceException e) {
            throw new WfsException(e);
        }
    }
}

