/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLHandlerFeature;
import org.vfny.geoserver.wfs.requests.TransactionHandler;

public class TransactionFilterHandler
extends FilterFilter
implements GMLHandlerFeature {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private TransactionHandler parent;

    public TransactionFilterHandler(TransactionHandler parent, FeatureType schema) {
        super((FilterHandler)parent, schema);
        this.parent = parent;
    }

    public void geometry(Geometry geometry) {
        LOGGER.finest("filter handler got geometry");
        if (this.insideFilter) {
            LOGGER.finest("sending to filterfilter " + geometry);
            super.geometry(geometry);
        } else {
            LOGGER.finest("sending to transaction " + geometry);
            this.parent.geometry(geometry);
        }
    }

    public void feature(Feature feature) {
        LOGGER.finer("sending feature to transaction " + feature);
        this.parent.feature(feature);
    }
}

