/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.requests.LockRequest;
import org.vfny.geoserver.wfs.servlets.WFService;

public class FeatureWithLockRequest
extends FeatureRequest {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    protected int expiry = 0;

    public FeatureWithLockRequest(WFService service) {
        super(service);
        this.setRequest("GetFeatureWithLock");
    }

    public FeatureLock toFeatureLock() {
        if (this.handle == null || this.handle.length() == 0) {
            this.handle = "GeoServer";
        }
        if (this.expiry < 0) {
            return FeatureLockFactory.generate((String)this.handle, (long)this.expiry);
        }
        if (this.expiry == 0) {
            return FeatureLockFactory.generate((String)this.handle, (long)0L);
        }
        return FeatureLockFactory.generate((String)this.handle, (long)(this.expiry * 60 * 1000));
    }

    public LockRequest asLockRequest() {
        LockRequest lockRequest = new LockRequest((WFService)this.getServiceRef());
        lockRequest.setExpiry(this.expiry);
        Iterator i = this.queries.iterator();
        while (i.hasNext()) {
            Query curQuery = (Query)i.next();
            lockRequest.addLock(curQuery.getTypeName(), curQuery.getFilter(), curQuery.getHandle());
        }
        LOGGER.finest("returning: " + super.toString() + " as " + (Object)((Object)lockRequest));
        return lockRequest;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nGetFeatureWithLock");
        returnString.append(": " + this.handle);
        returnString.append("\n output format:" + this.outputFormat);
        returnString.append("\n max features:" + this.maxFeatures);
        returnString.append("\n version: " + this.version);
        returnString.append("\n queries: ");
        returnString.append("\n expiry: " + this.expiry);
        ListIterator iterator = this.queries.listIterator();
        while (iterator.hasNext()) {
            returnString.append(iterator.next().toString() + " \n");
        }
        return returnString.toString();
    }
}

