/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.vfny.geoserver.wfs.servlets.WFService;

public class DescribeRequest
extends WFSRequest {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    protected boolean allRequested = true;
    protected List featureTypes = new ArrayList();
    protected String outputFormat = "XMLSCHEMA";

    public DescribeRequest(WFService service) {
        super("DescribeFeatureType", service);
    }

    public String getRequest() {
        return "DESCRIBEFATURETYPE";
    }

    public boolean allRequested() {
        return this.allRequested;
    }

    public void setFeatureTypes(List featureTypes) {
        this.featureTypes = featureTypes;
        this.allRequested = false;
    }

    public void addFeatureType(String featureTypes) {
        this.featureTypes.add(featureTypes);
        this.allRequested = false;
    }

    public List getFeatureTypes() {
        return this.featureTypes;
    }

    public void setOutputFormat(String outputFormat) {
        if (outputFormat != null && !outputFormat.equals("")) {
            this.outputFormat = outputFormat;
        }
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String toString() {
        String returnString = "DescribeFeatureType Request [outputFormat: ";
        returnString = returnString + this.outputFormat + " [feature types: ";
        LOGGER.finest("all req: " + this.allRequested());
        if (this.allRequested()) {
            return returnString + " ALL ]";
        }
        ListIterator i = this.featureTypes.listIterator();
        while (i.hasNext()) {
            returnString = returnString + i.next();
            if (!i.hasNext()) continue;
            returnString = returnString + ", ";
        }
        return returnString + "]";
    }

    public boolean equals(Object o) {
        super.equals(o);
        if (!(o instanceof DescribeRequest)) {
            return false;
        }
        DescribeRequest eqRequest = (DescribeRequest)((Object)o);
        boolean isEqual = true;
        ListIterator internal = this.featureTypes.listIterator();
        ListIterator compare = eqRequest.getFeatureTypes().listIterator();
        if (eqRequest.allRequested()) {
            isEqual = this.allRequested() && isEqual;
            return isEqual;
        }
        while (internal.hasNext()) {
            if (compare.hasNext()) {
                isEqual = internal.next().equals(compare.next()) && isEqual;
                continue;
            }
            internal.next();
            isEqual = false;
        }
        if (compare.hasNext()) {
            return false;
        }
        return isEqual;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 23 * result + (this.featureTypes == null ? 0 : ((Object)this.featureTypes).hashCode());
        return result;
    }
}

