/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.wfs.requests.DescribeRequest;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DescribeHandler
extends XMLFilterImpl
implements ContentHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private DescribeRequest request = null;
    private String currentTag = "";
    private StringBuffer characters = new StringBuffer();

    public DescribeHandler(DescribeRequest request) {
        this.request = request;
    }

    public DescribeRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        LOGGER.finest("found start element: " + localName);
        this.characters.setLength(0);
        this.currentTag = localName;
        if (this.currentTag.equals("DescribeFeatureType")) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getLocalName(i).equals("outputFormat")) continue;
                LOGGER.finest("found outputFormat: " + atts.getValue(i));
                this.request.setOutputFormat(atts.getValue(i));
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finest("found end element: " + localName);
        this.handleCharacters();
        this.currentTag = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    private void handleCharacters() {
        if (this.characters.length() == 0) {
            return;
        }
        if (this.currentTag.equals("TypeName")) {
            this.request.addFeatureType(this.characters.toString());
            LOGGER.finest("added type name: " + this.characters);
            this.characters.setLength(0);
        }
    }
}

