/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.wms;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.WMSConfig;
import org.vfny.geoserver.form.data.FormUtils;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class WMSRenderingForm
extends ActionForm {
    List svgRenderers = new ArrayList();
    String svgRenderer;
    boolean svgAntiAlias;
    boolean globalWatermarking;
    String globalWatermarkingURL;
    int watermarkTransparency;
    int watermarkPosition;
    List intTypes;
    String allowInterpolation;
    private boolean svgAntiAliasChecked = false;
    private boolean globalWatermarkingChecked = false;

    public WMSRenderingForm() {
        this.svgRenderers.add("Simple");
        this.svgRenderers.add("Batik");
        this.svgAntiAlias = true;
        this.intTypes = new ArrayList();
        this.intTypes.add("Nearest");
        this.intTypes.add("Bilinear");
        this.intTypes.add("Bicubic");
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        ServletContext context = this.getServlet().getServletContext();
        WMSConfig config = (WMSConfig)context.getAttribute("Config.WMS");
        this.svgRenderer = config.getSvgRenderer();
        if (this.svgRenderer == null) {
            this.svgRenderer = "Simple";
        }
        this.svgAntiAlias = config.getSvgAntiAlias();
        this.globalWatermarking = config.getGlobalWatermarking();
        this.globalWatermarkingURL = config.getGlobalWatermarkingURL();
        this.watermarkTransparency = config.getWatermarkTransparency();
        this.watermarkPosition = config.getWatermarkPosition();
        this.allowInterpolation = config.getAllowInterpolation();
        if (this.allowInterpolation == null) {
            this.allowInterpolation = "Bilinear";
        }
    }

    public void setSvgRenderer(String svgRenderer) {
        this.svgRenderer = svgRenderer;
    }

    public String getSvgRenderer() {
        return this.svgRenderer;
    }

    public List getSvgRenderers() {
        return this.svgRenderers;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.svgAntiAliasChecked = true;
        this.svgAntiAlias = svgAntiAlias;
    }

    public boolean getSvgAntiAlias() {
        return this.svgAntiAlias;
    }

    public boolean isSvgAntiAliasChecked() {
        return this.svgAntiAliasChecked;
    }

    public void setAllowInterpolation(String allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
    }

    public String getAllowInterpolation() {
        return this.allowInterpolation;
    }

    public List getIntTypes() {
        return this.intTypes;
    }

    public void setEnabledChecked(boolean svgAntiAliasChecked) {
        this.svgAntiAliasChecked = svgAntiAliasChecked;
    }

    public boolean isGlobalWatermarking() {
        return this.globalWatermarking;
    }

    public void setGlobalWatermarking(boolean globalWatermarking) {
        this.globalWatermarkingChecked = true;
        this.globalWatermarking = globalWatermarking;
    }

    public boolean getGlobalWatermarking() {
        return this.globalWatermarking;
    }

    public boolean isGlobalWatermarkingChecked() {
        return this.globalWatermarkingChecked;
    }

    public String getGlobalWatermarkingURL() {
        return this.globalWatermarkingURL;
    }

    public void setGlobalWatermarkingURL(String globalWatermarkingURL) {
        this.globalWatermarkingURL = globalWatermarkingURL;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        if (this.globalWatermarkingURL != null && !"".equals(this.globalWatermarkingURL)) {
            URL url = null;
            try {
                url = new URL(this.globalWatermarkingURL);
            }
            catch (MalformedURLException e) {
                try {
                    if (GeoserverDataDirectory.findDataFile((String)this.globalWatermarkingURL).exists()) {
                        url = new URL("file://" + this.globalWatermarkingURL);
                        this.globalWatermarkingURL = "file://" + this.globalWatermarkingURL;
                    }
                }
                catch (MalformedURLException e1) {
                    // empty catch block
                }
            }
            if (url != null && (url.getProtocol() == null || url.getProtocol().equals("file"))) {
                File file = GeoserverDataDirectory.findDataFile((String)this.globalWatermarkingURL);
                FormUtils.checkFileExistsAndCanRead((File)file, (ActionErrors)errors);
            }
        }
        if (this.watermarkTransparency < 0 || this.watermarkTransparency > 100) {
            errors.add("watermarkTransparency", new ActionError("error.watermark.transparency.invalid"));
        }
        return errors;
    }

    public int getWatermarkTransparency() {
        return this.watermarkTransparency;
    }

    public void setWatermarkTransparency(int watermarkTransparency) {
        this.watermarkTransparency = watermarkTransparency;
    }

    public int getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public void setWatermarkPosition(int watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
    }
}

