/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.wms;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.config.WMSConfig;

public class WMSContentForm
extends ActionForm {
    private boolean enabled;
    private String onlineResource;
    private List baseMapLayers = new ArrayList();
    private List baseMapStyles = new ArrayList();
    private List baseMapTitles = new ArrayList();
    private List baseMapEnvelopes = new ArrayList();
    private int envIndex = -1;
    private HashMap minCPs = new HashMap();
    private HashMap maxCPs = new HashMap();
    private CoordinateReferenceSystem targetCRS = null;
    private List srsNames = new ArrayList();
    private int selectedLayer;
    private boolean enabledChecked = false;
    private String action;
    private Set capabilitiesCrs;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setBaseMapTitles(List titles) {
        this.baseMapTitles = titles;
    }

    public void setBaseMapTitle(int index, String value) {
        this.baseMapTitles.set(index, value);
    }

    public List getBaseMapTitles() {
        return this.baseMapTitles;
    }

    public String getBaseMapTitle(int index) {
        return (String)this.baseMapTitles.get(index);
    }

    public List getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public String getBaseMapLayers(int index) {
        return (String)this.baseMapLayers.get(index);
    }

    public void setBaseMapLayers(int index, String value) {
        this.baseMapLayers.set(index, value);
    }

    public void setBaseMapLayers(List layers) {
        this.baseMapLayers = layers;
    }

    public List getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public String getBaseMapStyles(int index) {
        return (String)this.baseMapStyles.get(index);
    }

    public void setBaseMapStyles(int index, String value) {
        this.baseMapStyles.set(index, value);
    }

    public void setBaseMapStyles(List styles) {
        this.baseMapStyles = styles;
    }

    public void setBaseMapEnvelopes(List envelopes) {
        this.baseMapEnvelopes = envelopes;
    }

    public void setBaseMapEnvelope(int index, GeneralEnvelope value) {
        this.baseMapEnvelopes.set(index, value);
    }

    public List getBaseMapEnvelopes() {
        return this.baseMapEnvelopes;
    }

    public GeneralEnvelope getBaseMapEnvelope(int index) {
        return (GeneralEnvelope)this.baseMapEnvelopes.get(index);
    }

    public double getMinX(int index) {
        GeneralEnvelope envelope = this.getBaseMapEnvelope(index);
        return envelope.getLowerCorner().getOrdinate(0);
    }

    public double getMinY(int index) {
        GeneralEnvelope envelope = this.getBaseMapEnvelope(index);
        return envelope.getLowerCorner().getOrdinate(1);
    }

    public double getMaxX(int index) {
        GeneralEnvelope envelope = this.getBaseMapEnvelope(index);
        return envelope.getUpperCorner().getOrdinate(0);
    }

    public double getMaxY(int index) {
        GeneralEnvelope envelope = this.getBaseMapEnvelope(index);
        return envelope.getUpperCorner().getOrdinate(1);
    }

    public void setMinX(int index, double value) {
        double[] minCP = (double[])this.minCPs.get(new Integer(index));
        if (minCP == null) {
            minCP = new double[2];
        }
        minCP[0] = value;
        this.minCPs.put(new Integer(index), minCP);
    }

    public void setMinY(int index, double value) {
        double[] minCP = (double[])this.minCPs.get(new Integer(index));
        if (minCP == null) {
            minCP = new double[2];
        }
        minCP[1] = value;
        this.minCPs.put(new Integer(index), minCP);
    }

    public void setMaxX(int index, double value) {
        double[] maxCP = (double[])this.maxCPs.get(new Integer(index));
        if (maxCP == null) {
            maxCP = new double[2];
        }
        maxCP[0] = value;
        this.maxCPs.put(new Integer(index), maxCP);
    }

    public void setMaxY(int index, double value) {
        double[] maxCP = (double[])this.maxCPs.get(new Integer(index));
        if (maxCP == null) {
            maxCP = new double[2];
        }
        maxCP[1] = value;
        this.maxCPs.put(new Integer(index), maxCP);
    }

    public String getSrsName(int index) {
        GeneralEnvelope envelope = this.getBaseMapEnvelope(index);
        if (envelope.getCoordinateReferenceSystem().getName().toString().equalsIgnoreCase("EPSG:WGS 84")) {
            return "EPSG:4326";
        }
        if (envelope.getCoordinateReferenceSystem().getIdentifiers().toArray().length > 0) {
            return envelope.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
        }
        return "EPSG:4326";
    }

    public void setSrsName(int index, String value) throws NoSuchAuthorityCodeException, FactoryException {
        this.envIndex = index;
        try {
            this.targetCRS = CRS.decode((String)value);
        }
        catch (Exception e) {
            this.targetCRS = null;
        }
        if (index >= this.srsNames.size()) {
            while (this.srsNames.size() <= index) {
                this.srsNames.add(null);
            }
        }
        this.srsNames.set(index, value);
    }

    public String getSrsNameActual(int index) {
        return (String)this.srsNames.get(index);
    }

    public void setEnabled(boolean b) {
        this.enabledChecked = true;
        this.enabled = b;
    }

    public void setOnlineResource(String string) {
        this.onlineResource = string;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        this.enabledChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        WMSConfig config = (WMSConfig)context.getAttribute("Config.WMS");
        this.enabled = config.isEnabled();
        URL url = config.getOnlineResource();
        this.onlineResource = url != null ? url.toString() : "";
        if (config.getBaseMapLayers() != null) {
            Iterator it = config.getBaseMapLayers().keySet().iterator();
            ArrayList<String> baseMapTitles = new ArrayList<String>();
            ArrayList<String> baseMapLayers = new ArrayList<String>();
            ArrayList<String> baseMapStyles = new ArrayList<String>();
            ArrayList<GeneralEnvelope> baseMapEnvelopes = new ArrayList<GeneralEnvelope>();
            while (it.hasNext()) {
                String baseMapTitle = (String)it.next();
                String baseMapLayerValues = (String)config.getBaseMapLayers().get(baseMapTitle);
                String baseMapStyleValues = (String)config.getBaseMapStyles().get(baseMapTitle);
                GeneralEnvelope baseMapEnvelopeValues = (GeneralEnvelope)config.getBaseMapEnvelopes().get(baseMapTitle);
                baseMapTitles.add(baseMapTitle);
                baseMapLayers.add(baseMapLayerValues);
                baseMapStyles.add(baseMapStyleValues);
                baseMapEnvelopes.add(baseMapEnvelopeValues);
            }
            this.baseMapTitles = baseMapTitles;
            this.baseMapLayers = baseMapLayers;
            this.baseMapStyles = baseMapStyles;
            this.baseMapEnvelopes = baseMapEnvelopes;
        }
        this.capabilitiesCrs = new TreeSet(config.getCapabilitiesCrs());
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.targetCRS == null && this.envIndex >= 0) {
            errors.add("onlineResource", new ActionError("error.wms.onlineResource.required", (Object)this.onlineResource));
        } else if (this.envIndex >= 0) {
            GeneralEnvelope envelope = this.getBaseMapEnvelope(this.envIndex);
            envelope.setEnvelope(new GeneralEnvelope((double[])this.minCPs.get(new Integer(this.envIndex)), (double[])this.maxCPs.get(new Integer(this.envIndex))));
            envelope.setCoordinateReferenceSystem(this.targetCRS);
            this.setBaseMapEnvelope(this.envIndex, envelope);
        }
        if (this.onlineResource == null || "".equals(this.onlineResource)) {
            errors.add("onlineResource", new ActionError("error.wms.onlineResource.required", (Object)this.onlineResource));
        } else {
            try {
                URL url = new URL(this.onlineResource);
            }
            catch (MalformedURLException badURL) {
                errors.add("onlineResource", new ActionError("error.wms.onlineResource.malformed", (Object)badURL));
            }
        }
        return errors;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public HashMap getMaxCPs() {
        return this.maxCPs;
    }

    public HashMap getMinCPs() {
        return this.minCPs;
    }

    public int getSelectedLayer() {
        return this.selectedLayer;
    }

    public void setSelectedLayer(int selectedLayer) {
        this.selectedLayer = selectedLayer;
    }

    public Set getCapabilitiesCrsList() {
        return new TreeSet(this.capabilitiesCrs);
    }

    public String getCapabilitiesCrs() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.capabilitiesCrs.iterator();
        while (it.hasNext()) {
            String epsgCode = (String)it.next();
            sb.append(epsgCode);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setCapabilitiesCrs(String commaSeparatedCrsCodes) {
        TreeSet<String> codes = new TreeSet<String>();
        StringTokenizer st = new StringTokenizer(commaSeparatedCrsCodes.trim(), ",");
        while (st.hasMoreTokens()) {
            String code = st.nextToken();
            if ((code = code.trim().toUpperCase()).indexOf(58) == -1) {
                code = "EPSG:" + code;
            }
            try {
                CRS.decode((String)code);
            }
            catch (Exception e) {
                continue;
            }
            codes.add(code);
        }
        this.capabilitiesCrs = codes;
    }
}

