/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;

public class UpdateGSAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward r1 = this.updateGeoserver(mapping, form, request, response);
        ActionForward r2 = this.updateValidation(mapping, form, request, response);
        this.getApplicationState().fireChange();
        return mapping.findForward("config");
    }

    public ActionForward updateGeoserver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        try {
            WCSDTO wcsDTO = this.getWCSConfig().toDTO();
            WMSDTO wmsDTO = this.getWMSConfig().toDTO();
            WFSDTO wfsDTO = this.getWFSConfig().toDTO();
            GeoServerDTO geoserverDTO = this.getGlobalConfig().toDTO();
            DataDTO dataDTO = this.getDataConfig().toDTO();
            int gsUs = geoserverDTO.getUpdateSequence();
            geoserverDTO.setUpdateSequence(gsUs + 1);
            this.getWFS(request).getRawData().load(dataDTO);
            this.getWFS(request).getGeoServer().load(geoserverDTO);
            this.getWCS(request).load(wcsDTO);
            this.getWFS(request).load(wfsDTO);
            this.getWMS(request).load(wmsDTO);
            this.getGlobalConfig().update(geoserverDTO);
            this.getApplicationState().notifyToGeoServer();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        this.getApplicationState(request).notifyToGeoServer();
        return mapping.findForward("config");
    }

    public ActionForward updateValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        GeoServer gs = (GeoServer)sc.getAttribute("GeoServer");
        this.getApplicationState(request).notifyToGeoServer();
        return mapping.findForward("config.validation");
    }
}

