/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.XMLConfigWriter;

public class SaveXMLAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward r1 = this.saveGeoserver(mapping, form, request, response);
        ActionForward r2 = this.saveValidation(mapping, form, request, response);
        this.getApplicationState(request).notifiySaveXML();
        return mapping.findForward("config");
    }

    private ActionForward saveGeoserver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            XMLConfigWriter.store((WCSDTO)this.getWCS(request).toDTO(), (WMSDTO)this.getWMS(request).toDTO(), (WFSDTO)this.getWFS(request).toDTO(), (GeoServerDTO)this.getWFS(request).getGeoServer().toDTO(), (DataDTO)this.getWFS(request).getRawData().toDTO(), (File)rootDir);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        return mapping.findForward("config");
    }

    private ActionForward saveValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        File rootDir;
        ServletContext sc = request.getSession().getServletContext();
        File dataDir = rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            File plugInDir = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(dataDir, "plugIns"), (boolean)true);
            File validationDir = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(dataDir, "validation"), (boolean)true);
        }
        catch (ConfigurationException confE) {
            throw new ServletException((Throwable)confE);
        }
        this.getApplicationState(request).notifiySaveXML();
        return mapping.findForward("config.validation");
    }
}

