/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.filters.BufferedRequestStream;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geotools.util.logging.Logging;

public class BufferedRequestWrapper
extends HttpServletRequestWrapper {
    protected HttpServletRequest myWrappedRequest;
    protected String myBuffer;
    protected ServletInputStream myStream = null;
    protected BufferedReader myReader = null;
    protected Map myParameterMap;
    protected Logger logger = Logging.getLogger((String)"org.geoserver.filters");

    public BufferedRequestWrapper(HttpServletRequest req, String buff) {
        super(req);
        this.myWrappedRequest = req;
        this.myBuffer = buff;
        this.logger.info("Created BufferedRequestWrapper with String: \"" + buff + "\" as buffer");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.myStream == null) {
            if (this.myReader == null) {
                this.myStream = new BufferedRequestStream(this.myBuffer);
            } else {
                throw new IOException("Requesting a stream after a reader is already in use!!");
            }
        }
        return this.myStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.myReader == null) {
            if (this.myStream == null) {
                this.myReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedRequestStream(this.myBuffer)));
            } else {
                throw new IOException("Requesting a reader after a stream is already in use!!");
            }
        }
        return this.myReader;
    }

    public String getParameter(String name) {
        this.parseParameters();
        List allValues = (List)this.myParameterMap.get(name);
        if (allValues != null && allValues.size() > 0) {
            return (String)allValues.get(0);
        }
        return null;
    }

    public Map getParameterMap() {
        this.parseParameters();
        TreeMap toArrays = new TreeMap();
        Iterator it = this.myParameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            toArrays.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return Collections.unmodifiableMap(toArrays);
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return new IteratorAsEnumeration(this, this.myParameterMap.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        this.parseParameters();
        List allValues = (List)this.myParameterMap.get(name);
        if (allValues != null && allValues.size() > 0) {
            return allValues.toArray(new String[0]);
        }
        return null;
    }

    protected void parseParameters() {
        if (this.myParameterMap != null) {
            return;
        }
        if (this.myWrappedRequest.getMethod().equals("POST") && this.myWrappedRequest.getContentType().equals("application/x-www-form-urlencoded")) {
            this.parseFormBody();
        } else {
            this.myParameterMap = super.getParameterMap();
        }
    }

    protected void parseFormBody() {
        this.myParameterMap = new TreeMap();
        String[] pairs = this.myBuffer.split("\\&");
        for (int i = 0; i < pairs.length; ++i) {
            this.parsePair(pairs[i]);
        }
    }

    protected void parsePair(String pair) {
        boolean index = false;
        String[] split = pair.split("=", 2);
        try {
            String value;
            String key = URLDecoder.decode(split[0], "UTF-8");
            String string = value = split.length > 1 ? URLDecoder.decode(split[1], "UTF-8") : "";
            if (!this.myParameterMap.containsKey(key)) {
                this.myParameterMap.put(key, new ArrayList());
            }
            ((List)this.myParameterMap.get(key)).add(value);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.severe("Failed to decode form values in LoggingFilter");
        }
    }
}

