/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.web.tiles;

import java.io.IOException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.DelegatingTilesRequestProcessor;

public class MultipleDelegatingTilesRequestProcessor
extends DelegatingTilesRequestProcessor {
    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        if (TilesRequestProcessor.log.isDebugEnabled()) {
            TilesRequestProcessor.log.debug((Object)("processForwardConfig(" + forward.getPath() + ", " + forward.getContextRelative() + ")"));
        }
        if (this.processTilesDefinition(forward.getPath(), false, request, response)) {
            if (TilesRequestProcessor.log.isDebugEnabled()) {
                TilesRequestProcessor.log.debug((Object)("  '" + forward.getPath() + "' - processed as definition"));
            }
            return;
        }
        if (TilesRequestProcessor.log.isDebugEnabled()) {
            TilesRequestProcessor.log.debug((Object)("  '" + forward.getPath() + "' - processed as uri"));
        }
        super.processForwardConfig(request, response, forward);
    }

    protected boolean processTilesDefinition(String definitionName, boolean contextRelative, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean doInclude = false;
        Controller controller = null;
        String uri = null;
        ComponentContext tileContext = null;
        try {
            tileContext = ComponentContext.getContext((ServletRequest)request);
            doInclude = tileContext != null;
            ComponentDefinition definition = null;
            if (this.definitionsFactory != null) {
                try {
                    definition = this.definitionsFactory.getDefinition(definitionName, (ServletRequest)request, this.getServletContext());
                }
                catch (NoSuchDefinitionException ex) {
                    TilesRequestProcessor.log.debug((Object)("NoSuchDefinitionException " + ex.getMessage()));
                }
                if (definition != null) {
                    uri = definition.getPath();
                    controller = definition.getOrCreateController();
                    if (tileContext == null) {
                        tileContext = new ComponentContext(definition.getAttributes());
                        ComponentContext.setContext((ComponentContext)tileContext, (ServletRequest)request);
                    } else {
                        tileContext.addMissing(definition.getAttributes());
                    }
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext((ComponentContext)tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            TilesRequestProcessor.log.error((Object)"Can't create associated controller", (Throwable)ex);
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (uri == null) {
            return false;
        }
        if (controller != null) {
            try {
                controller.execute(tileContext, request, response, this.getServletContext());
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (TilesRequestProcessor.log.isDebugEnabled()) {
            TilesRequestProcessor.log.debug((Object)("uri=" + uri + " doInclude=" + doInclude));
        }
        if (doInclude) {
            this.doInclude(uri, request, response);
        } else {
            this.doForward(uri, request, response);
        }
        return true;
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String forward = mapping.getForward();
        if (forward == null) {
            return true;
        }
        this.internalModuleRelativeForward(forward, request, response);
        return false;
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String include = mapping.getInclude();
        if (include == null) {
            return true;
        }
        this.internalModuleRelativeInclude(include, request, response);
        return false;
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        if (TilesRequestProcessor.log.isDebugEnabled()) {
            TilesRequestProcessor.log.debug((Object)(" Delegating via forward to '" + uri + "'"));
        }
        this.doForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        if (TilesRequestProcessor.log.isDebugEnabled()) {
            TilesRequestProcessor.log.debug((Object)(" Delegating via include to '" + uri + "'"));
        }
        this.doInclude(uri, request, response);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            URL resource = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getResource(uri).getURL();
            response.sendRedirect(resource.toString());
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
    }
}

