/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.StylesEditorForm;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.SAXParseException;

public class StylesEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Style newStyle;
        File styleDir;
        List l;
        DataConfig config = this.getDataConfig();
        StylesEditorForm stylesForm = (StylesEditorForm)form;
        FormFile file = stylesForm.getSldFile();
        String styleID = stylesForm.getStyleID();
        String originalStyleID = stylesForm.getOriginalStyleId();
        StyleConfig style = user.getStyle();
        boolean doFullValidation = stylesForm.getFullyValidate();
        String action = stylesForm.getAction();
        String sldContents = stylesForm.getSldContents();
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String UPLOAD = HTMLEncoder.decode((String)messages.getMessage(locale, "label.upload"));
        if (UPLOAD.equals(action)) {
            stylesForm.setSldContents(this.readSldContents(file));
            return mapping.findForward("config.data.style.editor");
        }
        if (!stylesForm.getFullyValidateChecked()) {
            doFullValidation = false;
        }
        if (doFullValidation && (l = this.getSchemaExceptions(sldContents, request)).size() != 0) {
            this.handleValidationErrors(l, sldContents, stylesForm);
            return mapping.findForward("schemaErrors");
        }
        if (style == null) {
            return mapping.findForward("config.data.style");
        }
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            styleDir = GeoserverDataDirectory.findConfigDir((File)rootDir, (String)"styles");
        }
        catch (ConfigurationException cfe) {
            GeoServerAction.LOGGER.warning("no style dir found, creating new one");
            styleDir = new File(rootDir, "styles");
        }
        StyleConfig styleForID = config.getStyle(originalStyleID);
        File newSldFile = null;
        if (styleForID != null) {
            File oldFile;
            newSldFile = oldFile = styleForID.getFilename();
        } else {
            newSldFile = new File(styleDir, styleID + ".sld");
            if (newSldFile.exists()) {
                this.doFileExistsError(newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
        }
        GeoServerAction.LOGGER.fine("new sld file is: " + newSldFile + ", exists: " + newSldFile.exists());
        FileWriter fw = new FileWriter(newSldFile);
        fw.write(sldContents);
        fw.flush();
        fw.close();
        style.setFilename(newSldFile);
        style.setId(styleID);
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        SLDParser styleReader = new SLDParser(factory, newSldFile.toURL());
        Style[] readStyles = null;
        try {
            readStyles = styleReader.readXML();
            if (readStyles.length == 0) {
                String message = "The xml was valid, but couldn't get a Style from it.  Make sure your style validates against  the SLD schema";
                this.doStyleParseError(message, newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
            newStyle = readStyles[0];
            GeoServerAction.LOGGER.fine("sld is " + newStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage();
            this.doStyleParseError(message, newSldFile, request);
            return mapping.findForward("config.data.style.editor");
        }
        if (newStyle == null) {
            throw new RuntimeException("new style equals null");
        }
        config.removeStyle(originalStyleID);
        config.addStyle(style.getId(), style);
        this.getApplicationState().notifyConfigChanged();
        return mapping.findForward("config.data.style");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSldContents(FormFile file) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleValidationErrors(List errors, String sldContents, StylesEditorForm stylesForm) {
        ArrayList<String> lines;
        block18: {
            SAXParseException sax;
            lines = new ArrayList<String>();
            BufferedReader reader = null;
            reader = new BufferedReader(new StringReader(sldContents));
            String line = reader.readLine();
            int linenumber = 1;
            int exceptionNum = 0;
            if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                lines.add("   INVALID XML: " + sax.getLocalizedMessage());
                lines.add(" ");
                exceptionNum = 1;
            }
            while (line != null) {
                line.replace('\n', ' ');
                line.replace('\r', ' ');
                String header = linenumber + ": ";
                lines.add(header + line);
                boolean keep_going = true;
                while (keep_going) {
                    if (exceptionNum < errors.size()) {
                        SAXParseException sax2 = (SAXParseException)errors.get(exceptionNum);
                        if (sax2.getLineNumber() <= linenumber) {
                            String head = "---------------------".substring(0, header.length() - 1);
                            String body = "------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                            int colNum = sax2.getColumnNumber();
                            if (colNum < 1) {
                                colNum = 1;
                            }
                            lines.add(head + body.substring(0, sax2.getColumnNumber() - 1) + "^");
                            lines.add("       " + sax2.getLocalizedMessage());
                            ++exceptionNum;
                            continue;
                        }
                        keep_going = false;
                        continue;
                    }
                    keep_going = false;
                }
                line = reader.readLine();
                ++linenumber;
            }
            for (int t = exceptionNum; t < errors.size(); ++t) {
                SAXParseException sax3 = (SAXParseException)errors.get(t);
                lines.add("       " + sax3.getLocalizedMessage());
            }
            Object var16_19 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block18;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block18;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var16_20 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        stylesForm.setValidationReport(lines.toArray(new String[1]));
    }

    private List getSchemaExceptions(String sldContents, HttpServletRequest request) {
        SLDValidator validator = new SLDValidator();
        ServletContext sc = request.getSession().getServletContext();
        try {
            List l = validator.validateSLD((InputStream)new ByteArrayInputStream(sldContents.getBytes("UTF-8")), sc);
            return l;
        }
        catch (Exception e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private void doStyleParseError(String message, File newSldFile, HttpServletRequest request) {
        GeoServerAction.LOGGER.fine("parse error message is: " + message);
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.noParse", (Object)message));
        this.saveErrors(request, errors);
        newSldFile.delete();
    }

    private void doFileExistsError(File file, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.sldFileExists", (Object)file.getName()));
        this.saveErrors(request, errors);
    }
}

