/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.request;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.DispatcherKvpReader;
import org.vfny.geoserver.util.requests.readers.DispatcherXmlReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class Dispatcher
extends AbstractController {
    GeoServer geoServer;
    static /* synthetic */ Class class$org$vfny$geoserver$servlets$AbstractService;

    public Dispatcher(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        try {
            try {
                this.dispatch(httpRequest, httpResponse);
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (ServletException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        catch (ServiceException se) {
            String tempResponse = se.getXmlResponse(this.geoServer.isVerboseExceptions(), httpRequest, this.geoServer);
            httpResponse.setContentType(this.geoServer.getCharSet().toString());
            httpResponse.getWriter().write(tempResponse);
        }
        return null;
    }

    AbstractService find(String service, String request) throws ServiceException {
        List requests = GeoServerExtensions.extensions((Class)(class$org$vfny$geoserver$servlets$AbstractService == null ? (class$org$vfny$geoserver$servlets$AbstractService = Dispatcher.class$((String)"org.vfny.geoserver.servlets.AbstractService")) : class$org$vfny$geoserver$servlets$AbstractService));
        ArrayList<AbstractService> matches = new ArrayList<AbstractService>();
        Iterator itr = requests.iterator();
        while (itr.hasNext()) {
            AbstractService bean = (AbstractService)itr.next();
            if (service == null) {
                if (!bean.getRequest().toLowerCase().startsWith(request.toLowerCase().trim())) continue;
                matches.add(bean);
                continue;
            }
            if (!bean.getService().toLowerCase().startsWith(service.toLowerCase().trim()) || !bean.getRequest().equalsIgnoreCase(request.trim())) continue;
            matches.add(bean);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            String msg = "Multiple requests found capable of handling: (" + service + "," + request + ")";
            throw new ServiceException(msg);
        }
        return (AbstractService)matches.get(0);
    }

    void dispatch(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServiceException, IOException, ServletException {
        boolean isGet = "GET".equalsIgnoreCase(httpRequest.getMethod()) || httpRequest.getContentType() != null && httpRequest.getContentType().startsWith("application/x-www-form-urlencoded");
        String service = null;
        String request = null;
        Enumeration e = httpRequest.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if ("service".equalsIgnoreCase(key)) {
                service = httpRequest.getParameter(key);
            }
            if (!"request".equalsIgnoreCase(key)) continue;
            request = httpRequest.getParameter(key);
        }
        if (service == null || request == null) {
            String path = httpRequest.getContextPath();
            StringBuffer uriBuf = new StringBuffer(httpRequest.getRequestURI());
            while (uriBuf.indexOf("/") == 0) {
                uriBuf.deleteCharAt(0);
            }
            uriBuf.insert(0, "/");
            String uri = uriBuf.length() > path.length() ? uriBuf.substring(path.length() + 1) : uriBuf.toString();
            int index = uri.indexOf(47);
            if (index != -1) {
                if (service == null) {
                    service = uri.substring(0, index);
                }
                if (request == null) {
                    request = uri.substring(index + 1);
                }
            } else if (service == null) {
                service = uri;
            }
        }
        if (!(service != null && request != null || isGet)) {
            this.post(httpRequest, httpResponse);
            return;
        }
        AbstractService target = this.find(service, request);
        if (target != null) {
            if (isGet) {
                target.doGet(httpRequest, httpResponse);
            } else {
                target.doPost(httpRequest, httpResponse);
            }
        } else {
            String msg = "Could not locate service mapping to: (" + service + "," + request + ")";
            throw new ServiceException(msg);
        }
    }

    void post(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServiceException, IOException, ServletException {
        BufferedReader requestReader;
        BufferedReader disReader;
        int c;
        File temp;
        BufferedInputStream is = new BufferedInputStream((InputStream)httpRequest.getInputStream());
        long sequence = new Date().getTime();
        try {
            temp = File.createTempFile("dispatch" + sequence, "tmp");
            if (!temp.canRead() || !temp.canWrite()) {
                String errorMsg = "Temporary-file permission problem for location: " + temp.getPath();
                throw new IOException(errorMsg);
            }
        }
        catch (IOException e) {
            String errorMsg = "Possible file permission problem. Root cause: \n" + e.toString();
            IOException newE = new IOException(errorMsg);
            throw newE;
        }
        FileOutputStream fos = new FileOutputStream(temp);
        BufferedOutputStream out = new BufferedOutputStream(fos);
        while (-1 != (c = ((InputStream)is).read())) {
            out.write(c);
        }
        ((InputStream)is).close();
        out.flush();
        out.close();
        EncodingInfo encInfo = new EncodingInfo();
        try {
            disReader = new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(temp), (EncodingInfo)encInfo));
            requestReader = new BufferedReader(XmlCharsetDetector.createReader((InputStream)new FileInputStream(temp), (EncodingInfo)encInfo));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        AbstractService target = null;
        boolean kvpRequestContent = false;
        if (disReader != null) {
            try {
                DispatcherXmlReader requestTypeAnalyzer = new DispatcherXmlReader();
                requestTypeAnalyzer.read((Reader)disReader, httpRequest);
                target = this.find(requestTypeAnalyzer.getService(), requestTypeAnalyzer.getRequest());
            }
            catch (ServiceException e) {
                DispatcherKvpReader requestTypeAnalyzer = new DispatcherKvpReader();
                requestTypeAnalyzer.read(requestReader, httpRequest);
                target = this.find(requestTypeAnalyzer.getService(), requestTypeAnalyzer.getRequest());
                target.setKvpString(requestTypeAnalyzer.getQueryString());
                kvpRequestContent = true;
            }
        }
        if (target == null) {
            String msg = "Could not locate service for request";
            throw new ServiceException(msg);
        }
        if (!kvpRequestContent) {
            if (requestReader != null) {
                target.doPost(httpRequest, httpResponse, (Reader)requestReader);
            } else {
                target.doPost(httpRequest, httpResponse);
            }
        } else {
            target.doGet(httpRequest, httpResponse);
        }
        disReader.close();
        requestReader.close();
        temp.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

