/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GZIPResponseStream;
import org.geotools.util.logging.Logging;

public class AlternativesResponseStream
extends ServletOutputStream {
    HttpServletResponse myResponse;
    ServletOutputStream myStream;
    Set myCompressibleTypes;
    Logger logger = Logging.getLogger((String)"org.geoserver.filters");

    public AlternativesResponseStream(HttpServletResponse response, Set compressible) throws IOException {
        this.myResponse = response;
        this.myCompressibleTypes = compressible;
    }

    public void close() throws IOException {
        if (this.isDirty()) {
            this.getStream().close();
        }
    }

    public void flush() throws IOException {
        if (this.isDirty()) {
            this.getStream().flush();
        }
    }

    public void write(int b) throws IOException {
        this.getStream().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.getStream().write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.getStream().write(b, off, len);
    }

    protected ServletOutputStream getStream() throws IOException {
        if (this.myStream != null) {
            return this.myStream;
        }
        String type = this.myResponse.getContentType();
        if (type == null) {
            this.logger.warning("Mime type was not set before first write!");
        }
        if (type != null && this.isCompressible(type)) {
            this.logger.info("Compressing output for mimetype: " + type);
            this.myStream = new GZIPResponseStream(this.myResponse);
        } else {
            this.logger.info("Not compressing output for mimetype: " + type);
            this.myStream = this.myResponse.getOutputStream();
        }
        return this.myStream;
    }

    protected boolean isDirty() {
        return this.myStream != null;
    }

    protected boolean isCompressible(String mimetype) {
        String stripped = this.stripParams(mimetype);
        Iterator it = this.myCompressibleTypes.iterator();
        while (it.hasNext()) {
            Pattern pat = (Pattern)it.next();
            Matcher matcher = pat.matcher(stripped);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected String stripParams(String mimetype) {
        int firstSemicolon = mimetype.indexOf(";");
        if (firstSemicolon != -1) {
            return mimetype.substring(0, firstSemicolon);
        }
        return mimetype;
    }
}

