/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geoserver.wfs.WFS;
import org.geotools.validation.xml.XMLReader;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.config.validation.ValidationConfig;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.XMLConfigReader;

public class LoadXMLAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward r1 = this.loadValidation(mapping, form, request, response);
        ActionForward r2 = this.loadGeoserver(mapping, form, request, response);
        return mapping.findForward("config");
    }

    private ActionForward loadGeoserver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        XMLConfigReader configReader;
        ServletContext sc = request.getSession().getServletContext();
        WMSDTO wmsDTO = null;
        WFSDTO wfsDTO = null;
        WCSDTO wcsDTO = null;
        GeoServerDTO geoserverDTO = null;
        DataDTO dataDTO = null;
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            configReader = new XMLConfigReader(rootDir, sc);
        }
        catch (ConfigurationException configException) {
            configException.printStackTrace();
            return mapping.findForward("welcome");
        }
        if (!configReader.isInitialized()) {
            System.err.println("Config Reader not initialized for LoadXMLAction.execute().");
            return mapping.findForward("welcome");
        }
        wmsDTO = configReader.getWms();
        wfsDTO = configReader.getWfs();
        wcsDTO = configReader.getWcs();
        geoserverDTO = configReader.getGeoServer();
        dataDTO = configReader.getData();
        try {
            this.getWCS(request).load(wcsDTO);
            this.getWFS(request).load(wfsDTO);
            this.getWMS(request).load(wmsDTO);
            this.getWCS(request).getGeoServer().load(geoserverDTO);
            this.getWCS(request).getData().load(dataDTO);
            this.getWFS(request).getGeoServer().load(geoserverDTO);
            this.getWFS(request).getData().load(dataDTO);
        }
        catch (ConfigurationException configException) {
            configException.printStackTrace();
            return mapping.findForward("welcome");
        }
        this.getGlobalConfig().update(geoserverDTO);
        this.getDataConfig().update(dataDTO);
        this.getWCSConfig().update(wcsDTO);
        this.getWFSConfig().update(wfsDTO);
        this.getWMSConfig().update(wmsDTO);
        this.getApplicationState(request).notifyLoadXML();
        if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
            GeoServerAction.LOGGER.finer("request: " + request.getServletPath());
            GeoServerAction.LOGGER.finer("forward: " + mapping.getForward());
        }
        return mapping.findForward("config");
    }

    private ActionForward loadValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        WFS wfs = this.getWFS(request);
        if (wfs == null) {
            this.loadGeoserver(mapping, form, request, response);
        }
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            File plugInDir = this.findConfigDir(rootDir, "plugIns");
            File validationDir = this.findConfigDir(rootDir, "validation");
            Map plugIns = XMLReader.loadPlugIns((File)plugInDir);
            Map testSuites = XMLReader.loadValidations((File)validationDir, (Map)plugIns);
            ValidationConfig vc = new ValidationConfig(plugIns, testSuites);
            sc.setAttribute("Validation.Config", (Object)vc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("config.validation");
        }
        return mapping.findForward("config.validation");
    }

    private File findConfigDir(File rootDir, String name) throws Exception {
        return GeoserverDataDirectory.findConfigDir((File)rootDir, (String)name);
    }
}

