/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.wcs;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.WCSConfig;

public class WCSContentForm
extends ActionForm {
    private static final long serialVersionUID = 3977860674510534961L;
    private boolean enabled;
    private String onlineResource;
    private String describeURL;
    private boolean enabledChecked = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setDescribeURL(String string) {
        this.describeURL = string;
    }

    public void setEnabled(boolean b) {
        this.enabledChecked = true;
        this.enabled = b;
    }

    public void setOnlineResource(String string) {
        this.onlineResource = string;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        this.enabledChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        WCSConfig config = (WCSConfig)context.getAttribute("Config.WCS");
        this.enabled = config.isEnabled();
        URL url = config.getOnlineResource();
        this.onlineResource = url != null ? url.toString() : "";
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.onlineResource == null || "".equals(this.onlineResource)) {
            errors.add("onlineResource", new ActionError("error.wcs.onlineResource.required"));
        } else {
            try {
                URL url = new URL(this.onlineResource);
            }
            catch (MalformedURLException badURL) {
                errors.add("onlineResource", new ActionError("error.wcs.onlineResource.malformed", (Object)badURL));
            }
        }
        return errors;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }
}

