/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class StylesSelectForm
extends ActionForm {
    private String selectedStyle;
    private String action;
    private TreeSet styles;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        super.reset(arg0, request);
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        this.styles = new TreeSet();
        Iterator i = config.getStyles().values().iterator();
        boolean defaultSet = false;
        while (i.hasNext()) {
            StyleConfig sc = (StyleConfig)i.next();
            if (sc.isDefault()) {
                this.styles.add(sc.getId() + "*");
                defaultSet = true;
                continue;
            }
            this.styles.add(sc.getId());
        }
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        this.selectedStyle = "";
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.selectedStyle == null || "".equals(this.selectedStyle)) {
            errors.add("selectedStyle", new ActionError("error.style.required", (Object)this.selectedStyle));
        }
        if (!this.styles.contains(this.selectedStyle)) {
            errors.add("selectedStyle", new ActionError("error.style.invalid", (Object)this.selectedStyle));
        }
        return errors;
    }

    public String getSelectedStyle() {
        return this.selectedStyle;
    }

    public void setSelectedStyle(String selectedStyle) {
        this.selectedStyle = selectedStyle;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public TreeSet getStyles() {
        Object[] keys = this.styles.toArray();
        Arrays.sort(keys);
        TreeSet<Object> sorted = new TreeSet<Object>();
        for (int i = 0; i < keys.length; ++i) {
            sorted.add(keys[i]);
        }
        return sorted;
    }
}

