/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.Arrays;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class DataNamespacesSelectForm
extends ActionForm {
    private String selectedNamespace;
    private String action;
    private TreeSet namespaces;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        super.reset(arg0, request);
        this.action = "";
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        if (user == null) {
            return;
        }
        this.selectedNamespace = user.getPrefix();
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        this.namespaces = new TreeSet(config.getNameSpaces().keySet());
        String def = config.getDefaultNameSpace().getPrefix();
        if (this.namespaces.contains(def)) {
            this.namespaces.remove(def);
            this.namespaces.add(def + "*");
        }
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.getSelectedNamespace() == null || this.getSelectedNamespace().equalsIgnoreCase("")) {
            return errors;
        }
        return errors;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getSelectedNamespace() {
        return this.selectedNamespace;
    }

    public void setSelectedNamespace(String selectedNamespace) {
        this.selectedNamespace = selectedNamespace;
    }

    public TreeSet getNamespaces() {
        Object[] keys = this.namespaces.toArray();
        Arrays.sort(keys);
        TreeSet<Object> sorted = new TreeSet<Object>();
        for (int i = 0; i < keys.length; ++i) {
            sorted.add(keys[i]);
        }
        return sorted;
    }
}

