/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.util.MessageResources;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.CoverageConfig;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.AttributeDisplay;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.CoverageStoreUtils;
import org.vfny.geoserver.util.CoverageUtils;
import org.vfny.geoserver.util.Requests;

public final class CoveragesEditorForm
extends ActionForm {
    private static final long serialVersionUID = 1831907046971087321L;
    private String formatId;
    private String styleId;
    private SortedSet panelStyleIds;
    private SortedSet typeStyles;
    private String[] otherSelectedStyles;
    private String name;
    private String wmsPath;
    private String label;
    private String description;
    private String metadataLink;
    private String boundingBoxMinX;
    private String boundingBoxMinY;
    private String boundingBoxMaxX;
    private String boundingBoxMaxY;
    private String keywords;
    private SortedSet styles;
    private String srsName;
    private String WKTString;
    private String requestCRSs;
    private String responseCRSs;
    private String nativeFormat;
    private String supportedFormats;
    private String defaultInterpolationMethod;
    private String interpolationMethods;
    private String action;
    private String newCoverage;
    private List paramHelp;
    private List paramKeys;
    private List paramValues;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        String CRS2;
        Iterator<Object> i;
        super.reset(mapping, request);
        this.action = "";
        this.newCoverage = "";
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        CoverageConfig type = user.getCoverageConfig();
        if (type == null) {
            return;
        }
        this.formatId = type.getFormatId();
        this.styleId = type.getDefaultStyle();
        CoverageConfig cvConfig = (CoverageConfig)request.getSession().getAttribute("selectedCoverage");
        GeneralEnvelope bounds = cvConfig.getEnvelope();
        if (bounds.isNull()) {
            this.boundingBoxMinX = "";
        } else {
            this.boundingBoxMinX = Double.toString(bounds.getLowerCorner().getOrdinate(0));
            this.boundingBoxMinY = Double.toString(bounds.getLowerCorner().getOrdinate(1));
            this.boundingBoxMaxX = Double.toString(bounds.getUpperCorner().getOrdinate(0));
            this.boundingBoxMaxY = Double.toString(bounds.getUpperCorner().getOrdinate(1));
        }
        this.srsName = cvConfig.getSrsName();
        this.WKTString = cvConfig.getSrsWKT();
        this.name = cvConfig.getName();
        this.wmsPath = cvConfig.getWmsPath();
        this.label = cvConfig.getLabel();
        this.description = cvConfig.getDescription();
        this.metadataLink = cvConfig.getMetadataLink() != null ? cvConfig.getMetadataLink().getAbout() : null;
        this.nativeFormat = cvConfig.getNativeFormat();
        this.defaultInterpolationMethod = cvConfig.getDefaultInterpolationMethod();
        StringBuffer buf = new StringBuffer();
        if (cvConfig.getKeywords() != null) {
            i = cvConfig.getKeywords().iterator();
            while (i.hasNext()) {
                String keyword = (String)i.next();
                buf.append(keyword);
                if (!i.hasNext()) continue;
                buf.append(" ");
            }
            this.keywords = buf.toString();
        }
        if (cvConfig.getRequestCRSs() != null) {
            buf = new StringBuffer();
            i = cvConfig.getRequestCRSs().iterator();
            while (i.hasNext()) {
                CRS2 = (String)i.next();
                buf.append(CRS2.toUpperCase());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            this.requestCRSs = buf.toString();
        }
        if (cvConfig.getResponseCRSs() != null) {
            buf = new StringBuffer();
            i = cvConfig.getResponseCRSs().iterator();
            while (i.hasNext()) {
                CRS2 = (String)i.next();
                buf.append(CRS2.toUpperCase());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            this.responseCRSs = buf.toString();
        }
        if (cvConfig.getSupportedFormats() != null) {
            buf = new StringBuffer();
            i = cvConfig.getSupportedFormats().iterator();
            while (i.hasNext()) {
                String format = (String)i.next();
                buf.append(format.toUpperCase());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            this.supportedFormats = buf.toString();
        }
        if (cvConfig.getInterpolationMethods() != null) {
            buf = new StringBuffer();
            i = cvConfig.getInterpolationMethods().iterator();
            while (i.hasNext()) {
                String intMethod = (String)i.next();
                buf.append(intMethod.toLowerCase());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            this.interpolationMethods = buf.toString();
        }
        this.styles = new TreeSet();
        i = config.getStyles().values().iterator();
        while (i.hasNext()) {
            StyleConfig sc = (StyleConfig)i.next();
            this.styles.add(sc.getId());
            if (!sc.isDefault() || this.styleId != null && !"".equals(this.styleId)) continue;
            this.styleId.equals(sc.getId());
        }
        this.typeStyles = new TreeSet();
        i = ((AbstractList)type.getStyles()).iterator();
        while (i.hasNext()) {
            String styleName = (String)i.next();
            this.typeStyles.add(styleName);
        }
        if (this.styles instanceof AttributeDisplay) {
            // empty if block
        }
        Iterator it = type.getParameters().keySet().iterator();
        ArrayList<String> paramHelp = new ArrayList<String>();
        ArrayList<String> paramKeys = new ArrayList<String>();
        ArrayList<String> paramValues = new ArrayList<String>();
        while (it.hasNext()) {
            String paramKey = (String)it.next();
            String paramValue = (String)type.getParameters().get(paramKey);
            paramHelp.add(paramKey);
            paramKeys.add(paramKey);
            paramValues.add(paramValue);
        }
        this.paramHelp = paramHelp;
        this.paramKeys = paramKeys;
        this.paramValues = paramValues;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        Locale locale = request.getLocale();
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String ENVELOPE = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String LOOKUP_SRS = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.lookupSRS.label"));
        if (this.action.startsWith("Up") || this.action.startsWith("Down") || this.action.startsWith("Remove") || ENVELOPE.equals(this.action)) {
            return errors;
        }
        DataConfig data = ConfigRequests.getDataConfig((HttpServletRequest)request);
        if (!data.getStyles().containsKey(this.styleId) && !"".equals(this.styleId)) {
            errors.add("styleId", new ActionError("error.styleId.notFound", (Object)this.styleId));
        }
        if (!LOOKUP_SRS.equals(this.action)) {
            if (!this.srsName.toUpperCase().startsWith("EPSG:")) {
                this.srsName = "EPSG:" + this.srsName;
            }
            try {
                CRS.decode((String)this.srsName);
            }
            catch (Exception e) {
                errors.add("envelope", new ActionError("config.data.coverage.srs", (Object)this.srsName));
            }
        }
        if ("".equals(this.boundingBoxMinX) || "".equals(this.boundingBoxMinY) || "".equals(this.boundingBoxMaxX) || "".equals(this.boundingBoxMaxY)) {
            errors.add("envelope", new ActionError("error.envelope.required"));
        } else {
            try {
                Double.parseDouble(this.boundingBoxMinX);
                Double.parseDouble(this.boundingBoxMinY);
                Double.parseDouble(this.boundingBoxMaxX);
                Double.parseDouble(this.boundingBoxMaxY);
            }
            catch (NumberFormatException badNumber) {
                errors.add("envelope", new ActionError("error.envelope.invalid", (Object)badNumber));
            }
        }
        if ("".equals(this.name)) {
            errors.add("name", new ActionError("error.coverage.name.required"));
        } else if (this.name.indexOf(" ") > 0) {
            errors.add("name", new ActionError("error.coverage.name.invalid"));
        }
        DataConfig dataConfig = this.getDataConfig(request);
        CoverageStoreConfig cvConfig = dataConfig.getDataFormat(this.formatId);
        if (cvConfig == null) {
            throw new RuntimeException("selectedDataFormatId required in Session");
        }
        Format factory = cvConfig.getFactory();
        ParameterValueGroup info = factory.getReadParameters();
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        if (this.paramKeys != null) {
            String size = null;
            int length = this.paramKeys.size();
            String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            for (int i = 0; i < length; ++i) {
                String key = this.getParamKey(i);
                if (key.equalsIgnoreCase(readGeometryKey)) continue;
                ParameterValue param = CoverageStoreUtils.find((ParameterValueGroup)info, (String)key);
                if (param == null) {
                    errors.add("paramValue[" + i + "]", new ActionError("error.dataFormatEditor.param.missing", (Object)key, (Object)factory.getDescription()));
                    continue;
                }
                Boolean maxSize = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxSize != null && maxSize.booleanValue()) {
                    size = null;
                    ControllerConfig cc = mapping.getModuleConfig().getControllerConfig();
                    size = cc == null ? Long.toString(0xFA00000L) : cc.getMaxFileSize();
                    errors.add("styleID", new ActionError("error.file.maxLengthExceeded", (Object)size));
                    return errors;
                }
                Object value = CoverageUtils.getCvParamValue((String)key, (ParameterValue)param, (List)this.paramValues, (int)i);
                if (value == null) continue;
                connectionParams.put(key, value);
            }
        }
        return errors;
    }

    protected DataConfig getDataConfig(HttpServletRequest request) {
        return (DataConfig)request.getSession().getServletContext().getAttribute("Config.Data");
    }

    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    public void setDefaultInterpolationMethod(String defaultInterpolationMethod) {
        this.defaultInterpolationMethod = defaultInterpolationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMaxX() {
        return this.boundingBoxMaxX;
    }

    public void setMaxX(String boundingBoxMaxX) {
        this.boundingBoxMaxX = boundingBoxMaxX;
    }

    public String getMaxY() {
        return this.boundingBoxMaxY;
    }

    public void setMaxY(String boundingBoxMaxY) {
        this.boundingBoxMaxY = boundingBoxMaxY;
    }

    public String getMinX() {
        return this.boundingBoxMinX;
    }

    public void setMinX(String boundingBoxMinX) {
        this.boundingBoxMinX = boundingBoxMinX;
    }

    public String getMinY() {
        return this.boundingBoxMinY;
    }

    public void setMinY(String boundingBoxMinY) {
        this.boundingBoxMinY = boundingBoxMinY;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNativeFormat() {
        return this.nativeFormat;
    }

    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public String getMetadataLink() {
        return this.metadataLink;
    }

    public void setMetadataLink(String metadataLink) {
        this.metadataLink = metadataLink;
    }

    public String getInterpolationMethods() {
        return this.interpolationMethods;
    }

    public void setInterpolationMethods(String interpolationMethods) {
        this.interpolationMethods = interpolationMethods;
    }

    public String getRequestCRSs() {
        return this.requestCRSs;
    }

    public void setRequestCRSs(String requestCRSs) {
        this.requestCRSs = requestCRSs;
    }

    public String getResponseCRSs() {
        return this.responseCRSs;
    }

    public void setResponseCRSs(String responseCRSs) {
        this.responseCRSs = responseCRSs;
    }

    public String getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(String supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public String getNewCoverage() {
        return this.newCoverage;
    }

    public void setNewCoverage(String newCoverage) {
        this.newCoverage = newCoverage;
    }

    public SortedSet getStyles() {
        return this.styles;
    }

    public void setStyles(SortedSet styles) {
        this.styles = styles;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getWKTString() {
        return this.WKTString;
    }

    public void setWKTString(String string) {
        this.WKTString = string;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public void setParamHelp(ArrayList paramHelp) {
        this.paramHelp = paramHelp;
    }

    public List getParamKeys() {
        return this.paramKeys;
    }

    public void setParamKeys(List paramKeys) {
        this.paramKeys = paramKeys;
    }

    public List getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List paramValues) {
        this.paramValues = paramValues;
    }

    public Map getParams() {
        HashMap map = new HashMap();
        if (this.paramKeys != null) {
            int size = this.paramKeys.size();
            for (int i = 0; i < size; ++i) {
                map.put(this.paramKeys.get(i), this.paramValues.get(i));
            }
        }
        return map;
    }

    public String getParamKey(int index) {
        return this.paramKeys.get(index).toString();
    }

    public String getParamValue(int index) {
        return this.paramValues.get(index).toString();
    }

    public void setParamValue(int index, String value) {
        this.paramValues.set(index, value);
    }

    public void setParamValues(int index, String value) {
        this.paramValues.set(index, value);
    }

    public String[] getParamHelp() {
        return this.paramHelp.toArray(new String[this.paramHelp.size()]);
    }

    public String getParamHelp(int index) {
        return this.paramHelp.get(index).toString();
    }

    public String[] getOtherSelectedStyles() {
        return this.otherSelectedStyles;
    }

    public void setOtherSelectedStyles(String[] otherSelectedStyles) {
        this.otherSelectedStyles = otherSelectedStyles;
    }

    public SortedSet getPanelStyleIds() {
        return this.panelStyleIds;
    }

    public SortedSet getTypeStyles() {
        return this.typeStyles;
    }
}

